/// <reference path="./internal_*.d.ts" />
declare namespace net.minecraft.world.level.levelgen.placement {
    class BiomeFilter extends Internal.PlacementFilter {
        static biome(): net.minecraft.world.level.levelgen.placement.BiomeFilter;
        static CODEC: Internal.Codec<net.minecraft.world.level.levelgen.placement.BiomeFilter>;
    }
    type BiomeFilter_ = BiomeFilter;
}
declare namespace dev.ftb.mods.ftblibrary.ui {
    abstract class Button extends dev.ftb.mods.ftblibrary.ui.Widget {
        constructor(panel: Internal.Panel_, t: net.minecraft.network.chat.Component_, i: Internal.Icon_)
        constructor(panel: Internal.Panel_)
        drawIcon(graphics: Internal.GuiGraphics_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        closeGui(): void;
        openGui(): void;
        setTitle(s: net.minecraft.network.chat.Component_): this;
        drawBackground(graphics: Internal.GuiGraphics_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        closeContextMenu(): void;
        setIcon(i: Internal.Icon_): this;
        closeGui(openPrevScreen: boolean): void;
        run(): void;
        abstract onClicked(arg0: Internal.MouseButton_): void;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        openGuiLater(): void;
        set title(s: net.minecraft.network.chat.Component_)
        set icon(i: Internal.Icon_)
    }
    type Button_ = Button;
}
declare namespace net.fabricmc.fabric.mixin.content.registry {
    interface HoeItemAccessor {
        getTillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>;
        get tillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>
    }
    type HoeItemAccessor_ = HoeItemAccessor;
}
declare namespace Internal {
    interface PreparableReloadListener {
        getName(): string;
        abstract reload(arg0: Internal.PreparableReloadListener$PreparationBarrier_, arg1: Internal.ResourceManager_, arg2: Internal.ProfilerFiller_, arg3: Internal.ProfilerFiller_, arg4: Internal.Executor_, arg5: Internal.Executor_): Internal.CompletableFuture<void>;
        get name(): string
        (arg0: Internal.PreparableReloadListener$PreparationBarrier, arg1: Internal.ResourceManager, arg2: Internal.ProfilerFiller, arg3: Internal.ProfilerFiller, arg4: Internal.Executor, arg5: Internal.Executor): Internal.CompletableFuture_<void>;
    }
    type PreparableReloadListener_ = PreparableReloadListener;
    interface SimpleStateProviderAccessor {
        abstract getState(): Internal.BlockState;
        get state(): Internal.BlockState
        (): Internal.BlockState_;
    }
    type SimpleStateProviderAccessor_ = SimpleStateProviderAccessor;
    class MetalScaffoldingBlock extends Internal.ScaffoldingBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.CustomScaffoldingBlock {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isScaffolding(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, entity: Internal.LivingEntity_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MetalScaffoldingBlock_ = MetalScaffoldingBlock;
    abstract class BrainsweepeeIngredient {
        constructor()
        static getModNameComponent(namespace: string): net.minecraft.network.chat.Component;
        abstract ingrType(): Internal.BrainsweepeeIngredient$Type;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        static deserialize(json: Internal.JsonObject_): Internal.BrainsweepeeIngredient;
        abstract getName(): net.minecraft.network.chat.Component;
        abstract getTooltip(arg0: boolean): Internal.List<net.minecraft.network.chat.Component>;
        abstract test(arg0: Internal.Entity_, arg1: Internal.ServerLevel_): boolean;
        abstract getSomeKindOfReasonableIDForEmi(): string;
        abstract serialize(): Internal.JsonObject;
        static read(buf: Internal.FriendlyByteBuf_): Internal.BrainsweepeeIngredient;
        abstract exampleEntity(arg0: Internal.Level_): Internal.Entity;
        wrapWrite(buf: Internal.FriendlyByteBuf_): void;
        get name(): net.minecraft.network.chat.Component
        get someKindOfReasonableIDForEmi(): string
    }
    type BrainsweepeeIngredient_ = BrainsweepeeIngredient;
    abstract class ReentrantBlockableEventLoop <R extends Internal.Runnable> extends Internal.BlockableEventLoop<R> {
        constructor($$0: string)
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, R>): Internal.CompletableFuture<Source>;
        method_5384(): boolean;
        static of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): Internal.ProcessorHandle<Msg>;
        close(): void;
        method_18859($$0: R): void;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, R>): Internal.CompletableFuture<Source>;
    }
    type ReentrantBlockableEventLoop_<R extends Internal.Runnable> = ReentrantBlockableEventLoop<R>;
    class DrawableWidget extends Internal.Widget implements Internal.WidgetTooltipHolder<Internal.DrawableWidget> {
        constructor(x: number, y: number, w: number, h: number, consumer: Internal.DrawableWidget$DrawableWidgetConsumer_)
        tooltip(tooltip: Internal.List_<Internal.ClientTooltipComponent>): this;
        tooltip(tooltipSupplier: Internal.BiFunction_<number, number, Internal.List<Internal.ClientTooltipComponent>>): this;
        tooltipText(tooltip: Internal.List_<net.minecraft.network.chat.Component>): this;
        tooltipText(tooltipSupplier: Internal.BiFunction_<number, number, Internal.List<net.minecraft.network.chat.Component>>): this;
    }
    type DrawableWidget_ = DrawableWidget;
    class AnimationController <T extends Internal.GeoAnimatable> {
        constructor(animatable: T, transitionTickTime: number, animationHandler: Internal.AnimationController$AnimationStateHandler_<T>)
        constructor(animatable: T, name: string, animationHandler: Internal.AnimationController$AnimationStateHandler_<T>)
        constructor(animatable: T, animationHandler: Internal.AnimationController$AnimationStateHandler_<T>)
        constructor(animatable: T, name: string, transitionTickTime: number, animationHandler: Internal.AnimationController$AnimationStateHandler_<T>)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        setTransitionLength(ticks: number): void;
        setOverrideEasingTypeFunction(easingType: Internal.Function_<T, Internal.EasingType>): this;
        getStateHandler(): Internal.AnimationController$AnimationStateHandler<T>;
        process(model: Internal.CoreGeoModel_<T>, state: software.bernie.geckolib.core.animation.AnimationState_<T>, bones: Internal.Map_<string, Internal.CoreGeoBone>, snapshots: Internal.Map_<string, Internal.BoneSnapshot>, seekTime: number, crashWhenCantFindBone: boolean): void;
        getName(): string;
        setCustomInstructionKeyframeHandler(customInstructionHandler: Internal.AnimationController$CustomKeyframeHandler_<T>): this;
        hasAnimationFinished(): boolean;
        getAnimationSpeed(): number;
        tryTriggerAnimation(animName: string): boolean;
        isPlayingTriggeredAnimation(): boolean;
        transitionLength(ticks: number): this;
        getCurrentRawAnimation(): Internal.RawAnimation;
        receiveTriggeredAnimations(): this;
        setParticleKeyframeHandler(particleHandler: Internal.AnimationController$ParticleKeyframeHandler_<T>): this;
        getCurrentAnimation(): Internal.AnimationProcessor$QueuedAnimation;
        setOverrideEasingType(easingTypeFunction: Internal.EasingType_): this;
        getAnimationState(): Internal.AnimationController$State;
        setSoundKeyframeHandler(soundHandler: Internal.AnimationController$SoundKeyframeHandler_<T>): this;
        getBoneAnimationQueues(): Internal.Map<string, Internal.BoneAnimationQueue>;
        setAnimationSpeedHandler(speedModFunction: Internal.Function_<T, number>): this;
        triggerableAnim(name: string, animation: Internal.RawAnimation_): this;
        setAnimationSpeed(speed: number): this;
        setAnimation(rawAnimation: Internal.RawAnimation_): void;
        forceAnimationReset(): void;
        stop(): void;
        getTriggeredAnimation(): Internal.RawAnimation;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        set transitionLength(ticks: number)
        set overrideEasingTypeFunction(easingType: Internal.Function_<T, Internal.EasingType>)
        get stateHandler(): Internal.AnimationController$AnimationStateHandler<T>
        get name(): string
        set customInstructionKeyframeHandler(customInstructionHandler: Internal.AnimationController$CustomKeyframeHandler_<T>)
        get animationSpeed(): number
        get playingTriggeredAnimation(): boolean
        get currentRawAnimation(): Internal.RawAnimation
        set particleKeyframeHandler(particleHandler: Internal.AnimationController$ParticleKeyframeHandler_<T>)
        get currentAnimation(): Internal.AnimationProcessor$QueuedAnimation
        set overrideEasingType(easingTypeFunction: Internal.EasingType_)
        get animationState(): Internal.AnimationController$State
        set soundKeyframeHandler(soundHandler: Internal.AnimationController$SoundKeyframeHandler_<T>)
        get boneAnimationQueues(): Internal.Map<string, Internal.BoneAnimationQueue>
        set animationSpeedHandler(speedModFunction: Internal.Function_<T, number>)
        set animationSpeed(speed: number)
        set animation(rawAnimation: Internal.RawAnimation_)
        get triggeredAnimation(): Internal.RawAnimation
    }
    type AnimationController_<T extends Internal.GeoAnimatable> = AnimationController<T>;
    class UIModel {
        expandTemplate<T extends io.wispforest.owo.ui.core.Component>(expectedClass: T, name: string, parameters: Internal.Map_<string, string>): T;
        static load(path: Internal.Path_): Internal.UIModel;
        static load(stream: Internal.InputStream_): Internal.UIModel;
        parseComponent<T extends io.wispforest.owo.ui.core.Component>(expectedClass: T, componentElement: Internal.Element_): T;
        expandTemplate<T extends io.wispforest.owo.ui.core.Component>(expectedClass: T, name: string, parameterSupplier: Internal.Function_<string, string>, childSupplier: Internal.Function_<string, Internal.Element>): T;
        createAdapterWithoutScreen<T extends Internal.ParentComponent>(x: number, y: number, width: number, height: number, expectedRootComponentClass: T): Internal.OwoUIAdapter<T>;
        createAdapter<T extends Internal.ParentComponent>(expectedRootComponentClass: T, screen: Internal.Screen_): Internal.OwoUIAdapter<T>;
    }
    type UIModel_ = UIModel;
    interface AccessibleEditableText extends Internal.AccessibleText {
        abstract getBeforeIndex(arg0: number, arg1: number): string;
        abstract getTextRange(arg0: number, arg1: number): string;
        abstract getSelectionStart(): number;
        abstract getSelectedText(): string;
        abstract setTextContents(arg0: string): void;
        abstract getAfterIndex(arg0: number, arg1: number): string;
        abstract setAttributes(arg0: number, arg1: number, arg2: Internal.AttributeSet_): void;
        abstract getCharacterBounds(arg0: number): Internal.Rectangle;
        abstract paste(arg0: number): void;
        abstract getIndexAtPoint(arg0: Internal.Point_): number;
        abstract getCharCount(): number;
        abstract getCharacterAttribute(arg0: number): Internal.AttributeSet;
        abstract selectText(arg0: number, arg1: number): void;
        abstract getAtIndex(arg0: number, arg1: number): string;
        abstract replaceText(arg0: number, arg1: number, arg2: string): void;
        abstract insertTextAtIndex(arg0: number, arg1: string): void;
        abstract getSelectionEnd(): number;
        abstract getCaretPosition(): number;
        abstract cut(arg0: number, arg1: number): void;
        abstract "delete"(arg0: number, arg1: number): void;
        get selectionStart(): number
        get selectedText(): string
        set textContents(arg0: string)
        get charCount(): number
        get selectionEnd(): number
        get caretPosition(): number
    }
    type AccessibleEditableText_ = AccessibleEditableText;
    class BezierConnection implements Internal.IHasTrackCasing, Internal.Iterable<Internal.BezierConnection$Segment> {
        constructor(buffer: Internal.FriendlyByteBuf_)
        constructor(compound: Internal.CompoundTag_, localTo: BlockPos_)
        constructor(positions: Internal.Couple_<BlockPos>, starts: Internal.Couple_<Vec3d>, axes: Internal.Couple_<Vec3d>, normals: Internal.Couple_<Vec3d>, primary: boolean, girder: boolean, material: Internal.TrackMaterial_)
        clone(): any;
        getRadius(): number;
        getGirderItemCost(): number;
        getBakedGirders(): Internal.BezierConnection$GirderAngles;
        getBounds(): Internal.AABB;
        getBakedSegments(): Internal.BezierConnection$SegmentAngles;
        equalsSansMaterial(other: Internal.BezierConnection_): boolean;
        secondary(): this;
        forEach(arg0: Internal.Consumer_<Internal.BezierConnection$Segment>): void;
        getStepLUT(): number[];
        yOffsetAt(end: Vec3d_): number;
        getMaterial(): Internal.TrackMaterial;
        static isAlternate(world: Internal.Level_, pos: BlockPos_): boolean;
        static setTrackCasing(world: Internal.Level_, pos: BlockPos_, trackCasing: Internal.SlabBlock_): void;
        rasterise(): Internal.Map<net.createmod.catnip.data.Pair<number, number>, number>;
        getSegmentCount(): number;
        write(localTo: BlockPos_): Internal.CompoundTag;
        isAlternate(): boolean;
        spawnDestroyParticles(level: Internal.Level_): void;
        write(buffer: Internal.FriendlyByteBuf_): void;
        incrementT(currentT: number, distance: number): number;
        setMaterial(material: Internal.TrackMaterial_): void;
        getKey(): BlockPos;
        getHandleLength(): number;
        static setAlternateModel(world: Internal.Level_, pos: BlockPos_, useAlternateModel: boolean): boolean;
        spliterator(): Internal.Spliterator<Internal.BezierConnection$Segment>;
        static getTrackCasing(world: Internal.Level_, pos: BlockPos_): Internal.SlabBlock;
        iterator(): Internal.Iterator<Internal.BezierConnection$Segment>;
        getTrackCasing(): Internal.SlabBlock;
        getNormal(t: number): Vec3d;
        setAlternate(alternate: boolean): void;
        addItemsToPlayer(player: Internal.Player_): void;
        getLength(): number;
        isPrimary(): boolean;
        getTrackItemCost(): number;
        spawnItems(level: Internal.Level_): void;
        getSegmentT(index: number): number;
        getPosition(t: number): Vec3d;
        setTrackCasing(trackCasing: Internal.SlabBlock_): void;
        get radius(): number
        get girderItemCost(): number
        get bakedGirders(): Internal.BezierConnection$GirderAngles
        get bounds(): Internal.AABB
        get bakedSegments(): Internal.BezierConnection$SegmentAngles
        get stepLUT(): number[]
        get material(): Internal.TrackMaterial
        get segmentCount(): number
        get alternate(): boolean
        set material(material: Internal.TrackMaterial_)
        get key(): BlockPos
        get handleLength(): number
        get trackCasing(): Internal.SlabBlock
        set alternate(alternate: boolean)
        get length(): number
        get primary(): boolean
        get trackItemCost(): number
        set trackCasing(trackCasing: Internal.SlabBlock_)
        readonly axes: Internal.Couple<Vec3d>;
        smoothing: Internal.Couple<number>;
        readonly normals: Internal.Couple<Vec3d>;
        readonly primary: boolean;
        readonly starts: Internal.Couple<Vec3d>;
        readonly bePositions: Internal.Couple<BlockPos>;
        readonly hasGirder: boolean;
    }
    type BezierConnection_ = BezierConnection;
    interface DoubleSpliterator extends Internal.Spliterator$OfDouble {
        forEachRemaining(arg0: any): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        getComparator(): Internal.Comparator<any>;
        hasCharacteristics(arg0: number): boolean;
        tryAdvance(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): boolean;
        skip(arg0: number): number;
        abstract estimateSize(): number;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        trySplit(): Internal.Spliterator<any>;
        getExactSizeIfKnown(): number;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        /**
         * @deprecated
        */
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        tryAdvance(arg0: any): boolean;
        abstract characteristics(): number;
        abstract tryAdvance(arg0: Internal.DoubleConsumer_): boolean;
        get comparator(): Internal.Comparator<any>
        get exactSizeIfKnown(): number
    }
    type DoubleSpliterator_ = DoubleSpliterator;
    interface LevelChunk$PostLoadProcessor {
        abstract run(arg0: Internal.LevelChunk_): void;
        (arg0: Internal.LevelChunk): void;
    }
    type LevelChunk$PostLoadProcessor_ = LevelChunk$PostLoadProcessor;
    class RadioBlock extends Internal.BasicEntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.EightDirectionProperty;
    }
    type RadioBlock_ = RadioBlock;
    interface IBlockTool {
        abstract method_7884(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        (arg0: Internal.UseOnContext): Internal.InteractionResult_;
    }
    type IBlockTool_ = IBlockTool;
    class AECableType extends Internal.Enum<Internal.AECableType> {
        isValid(): boolean;
        isSmart(): boolean;
        isDense(): boolean;
        static values(): Internal.AECableType[];
        size(): Internal.AECableSize;
        variant(): Internal.AECableVariant;
        static max(a: Internal.AECableType_, b: Internal.AECableType_): Internal.AECableType;
        static valueOf(name: string): Internal.AECableType;
        static min(a: Internal.AECableType_, b: Internal.AECableType_): Internal.AECableType;
        get valid(): boolean
        get smart(): boolean
        get dense(): boolean
        static readonly GLASS: Internal.AECableType;
        static readonly VALIDCABLES: Internal.AECableType[];
        static readonly SMART: Internal.AECableType;
        static readonly DENSE_SMART: Internal.AECableType;
        static readonly DENSE_COVERED: Internal.AECableType;
        static readonly NONE: Internal.AECableType;
        static readonly COVERED: Internal.AECableType;
    }
    type AECableType_ = "covered" | "smart" | AECableType | "glass" | "none" | "dense_covered" | "dense_smart";
    interface BakedQuadView extends Internal.ModelQuadView {
        abstract getFlags(): number;
        abstract getTexU(arg0: number): number;
        abstract getTexV(arg0: number): number;
        abstract getNormalFace(): Internal.ModelQuadFacing;
        abstract getSprite(): Internal.TextureAtlasSprite;
        abstract hasShade(): boolean;
        hasColor(): boolean;
        abstract getColor(arg0: number): number;
        abstract getLightFace(): Internal.Direction;
        abstract getZ(arg0: number): number;
        abstract getColorIndex(): number;
        abstract getX(arg0: number): number;
        abstract getY(arg0: number): number;
        get flags(): number
        get normalFace(): Internal.ModelQuadFacing
        get sprite(): Internal.TextureAtlasSprite
        get lightFace(): Internal.Direction
        get colorIndex(): number
    }
    type BakedQuadView_ = BakedQuadView;
    abstract class DirectionalFluid extends Internal.FlowingFluid {
        constructor(flowDirection: Internal.Direction_)
        method_15736(world: Internal.BlockGetter_, fluid: Internal.Fluid_, pos: BlockPos_, state: Internal.BlockState_, fromPos: BlockPos_, fromState: Internal.BlockState_): boolean;
        useDefaultRenderer(): boolean;
        static isFluidInDirectionEqual(state: Internal.FluidState_, world: Internal.BlockGetter_, pos: BlockPos_): boolean;
        getFlowDirection(): Internal.Direction;
        method_15740(world: Internal.LevelReader_, pos: BlockPos_): number;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
        get flowDirection(): Internal.Direction
    }
    type DirectionalFluid_ = DirectionalFluid;
    abstract class BlockBreakingKineticBlockEntity extends Internal.KineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        destroyNextTick(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        static isBreakable(stateToBreak: Internal.BlockState_, blockHardness: number): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        onBlockBroken(stateToBreak: Internal.BlockState_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        canBreak(stateToBreak: Internal.BlockState_, blockHardness: number): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        static readonly NEXT_BREAKER_ID: 0;
    }
    type BlockBreakingKineticBlockEntity_ = BlockBreakingKineticBlockEntity;
    class FishingLootEventJS extends Internal.LootEventJS {
        constructor(c: Internal.Map_<ResourceLocation, Internal.JsonElement>)
        addFishing(id: ResourceLocation_, b: Internal.Consumer_<Internal.LootBuilder>): void;
    }
    type FishingLootEventJS_ = FishingLootEventJS;
    class AccessibleRelationSet {
        constructor()
        constructor(arg0: Internal.AccessibleRelation_[])
        toArray(): Internal.AccessibleRelation[];
        size(): number;
        add(arg0: Internal.AccessibleRelation_): boolean;
        clear(): void;
        addAll(arg0: Internal.AccessibleRelation_[]): void;
        get(arg0: string): Internal.AccessibleRelation;
        remove(arg0: Internal.AccessibleRelation_): boolean;
        contains(arg0: string): boolean;
    }
    type AccessibleRelationSet_ = AccessibleRelationSet;
    abstract class ShoulderRidingEntity extends Internal.TamableAnimal {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setEntityOnShoulder($$0: Internal.ServerPlayer_): boolean;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        canSitOnShoulder(): boolean;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set entityOnShoulder($$0: Internal.ServerPlayer_)
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type ShoulderRidingEntity_ = ShoulderRidingEntity;
    class ForgeConfigSpec$DoubleValue extends Internal.ForgeConfigSpec$ConfigValue<number> {
    }
    type ForgeConfigSpec$DoubleValue_ = ForgeConfigSpec$DoubleValue;
    interface Matrix4fc {
        abstract project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
        abstract getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
        abstract get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): Matrix4f;
        abstract unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): Matrix4f;
        abstract scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): Matrix4f;
        abstract mapnZnYnX(arg0: Matrix4f_): Matrix4f;
        abstract get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        abstract pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): Matrix4f;
        abstract tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract rotateY(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
        abstract mapnXZY(arg0: Matrix4f_): Matrix4f;
        abstract ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract mapnXnZY(arg0: Matrix4f_): Matrix4f;
        abstract getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract mapXZY(arg0: Matrix4f_): Matrix4f;
        abstract perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): Matrix4f;
        abstract get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): Matrix4f;
        abstract mapXZnY(arg0: Matrix4f_): Matrix4f;
        abstract rotateLocalX(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract mapnZXY(arg0: Matrix4f_): Matrix4f;
        abstract rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): Matrix4f;
        abstract mapnYXnZ(arg0: Matrix4f_): Matrix4f;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract m31(): number;
        abstract mapYXnZ(arg0: Matrix4f_): Matrix4f;
        abstract getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformAffine(arg0: Vec4f_): Vec4f;
        abstract get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mapZnYnX(arg0: Matrix4f_): Matrix4f;
        abstract getRowColumn(arg0: number, arg1: number): number;
        abstract scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract positiveZ(arg0: Vec3f_): Vec3f;
        abstract negateY(arg0: Matrix4f_): Matrix4f;
        abstract mapZXY(arg0: Matrix4f_): Matrix4f;
        abstract cofactor3x3(arg0: Matrix3f_): Matrix3f;
        abstract lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): Matrix4f;
        abstract mapnYnXnZ(arg0: Matrix4f_): Matrix4f;
        abstract m20(): number;
        abstract mapXnZY(arg0: Matrix4f_): Matrix4f;
        abstract get(arg0: Matrix4f_): Matrix4f;
        abstract transform(arg0: Vec4f_): Vec4f;
        abstract orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): Matrix4f;
        abstract rotateX(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): Matrix4f;
        abstract perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract normal(arg0: Matrix4f_): Matrix4f;
        abstract rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract rotateLocalY(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): Matrix4f;
        abstract invertAffine(arg0: Matrix4f_): Matrix4f;
        abstract shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): Matrix4f;
        abstract mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): Matrix4f;
        abstract perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get3x3(arg0: Matrix3f_): Matrix3f;
        abstract normalize3x3(arg0: Matrix4f_): Matrix4f;
        abstract orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract m32(): number;
        abstract getScale(arg0: Vec3f_): Vec3f;
        abstract unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
        abstract rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract invertFrustum(arg0: Matrix4f_): Matrix4f;
        abstract lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): Matrix4f;
        abstract mapYnXnZ(arg0: Matrix4f_): Matrix4f;
        abstract negateZ(arg0: Matrix4f_): Matrix4f;
        abstract normal(arg0: Matrix3f_): Matrix3f;
        abstract lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        abstract rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): Matrix4f;
        abstract mapZnXnY(arg0: Matrix4f_): Matrix4f;
        abstract rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract m21(): number;
        abstract isFinite(): boolean;
        abstract get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        abstract rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): Matrix4f;
        abstract m10(): number;
        abstract shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): Matrix4f;
        abstract transpose3x3(arg0: Matrix4f_): Matrix4f;
        abstract mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): Matrix4f;
        abstract transformPosition(arg0: Vec3f_): Vec3f;
        abstract m33(): number;
        abstract transformDirection(arg0: Vec3f_): Vec3f;
        abstract perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): Matrix4f;
        abstract determinant3x3(): number;
        abstract mapYXZ(arg0: Matrix4f_): Matrix4f;
        abstract get(arg0: number, arg1: number): number;
        abstract transpose(arg0: Matrix4f_): Matrix4f;
        abstract orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): Matrix4f;
        abstract get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
        abstract transpose3x3(arg0: Matrix3f_): Matrix3f;
        abstract translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract m22(): number;
        abstract mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract perspectiveNear(): number;
        abstract rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): Matrix4f;
        abstract frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mapnYZX(arg0: Matrix4f_): Matrix4f;
        abstract rotateZ(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract mapZYX(arg0: Matrix4f_): Matrix4f;
        abstract mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): Matrix4f;
        abstract rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mapnZnXnY(arg0: Matrix4f_): Matrix4f;
        abstract shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): Matrix4f;
        abstract m11(): number;
        abstract mapYnZX(arg0: Matrix4f_): Matrix4f;
        abstract unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
        abstract project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
        abstract getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
        abstract transformTranspose(arg0: Vec4f_): Vec4f;
        abstract perspectiveOrigin(arg0: Vec3f_): Vec3f;
        abstract frustumAabb(arg0: Vec3f_, arg1: Vec3f_): Matrix4f;
        abstract get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract mapnYnXZ(arg0: Matrix4f_): Matrix4f;
        abstract rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): Matrix4f;
        abstract translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract mapZnYX(arg0: Matrix4f_): Matrix4f;
        abstract mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract mapnXnYZ(arg0: Matrix4f_): Matrix4f;
        abstract getToAddress(arg0: number): this;
        abstract rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mapXnYnZ(arg0: Matrix4f_): Matrix4f;
        abstract mapnZYnX(arg0: Matrix4f_): Matrix4f;
        abstract m00(): number;
        abstract transformProject(arg0: Vec4f_): Vec4f;
        abstract isAffine(): boolean;
        abstract get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): Matrix4f;
        abstract arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract m23(): number;
        abstract rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
        abstract lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): Matrix4f;
        abstract lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): Matrix4f;
        abstract frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
        abstract transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract m12(): number;
        abstract invertPerspective(arg0: Matrix4f_): Matrix4f;
        abstract get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mapnYnZX(arg0: Matrix4f_): Matrix4f;
        abstract frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
        abstract normalizedPositiveX(arg0: Vec3f_): Vec3f;
        abstract get(arg0: number[]): number[];
        abstract shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): Matrix4f;
        abstract orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mapnYnZnX(arg0: Matrix4f_): Matrix4f;
        abstract transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract getColumn(arg0: number, arg1: Vec3f_): Vec3f;
        abstract rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract get(arg0: number[], arg1: number): number[];
        abstract unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): Matrix4f;
        abstract orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): Matrix4f;
        abstract frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
        abstract mapZXnY(arg0: Matrix4f_): Matrix4f;
        abstract m01(): number;
        abstract rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract invert(arg0: Matrix4f_): Matrix4f;
        abstract mapnZYX(arg0: Matrix4f_): Matrix4f;
        abstract getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        abstract mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): Matrix4f;
        abstract sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract mapYZnX(arg0: Matrix4f_): Matrix4f;
        abstract perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
        abstract getRow(arg0: number, arg1: Vec4f_): Vec4f;
        abstract getColumn(arg0: number, arg1: Vec4f_): Vec4f;
        abstract getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): Matrix4f;
        abstract mapnZXnY(arg0: Matrix4f_): Matrix4f;
        abstract get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mapZnXY(arg0: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
        abstract transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): Matrix4f;
        abstract properties(): number;
        abstract rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): Matrix4f;
        abstract transformProject(arg0: Vec3f_): Vec3f;
        abstract frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract normalizedPositiveY(arg0: Vec3f_): Vec3f;
        abstract transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        abstract getRow(arg0: number, arg1: Vec3f_): Vec3f;
        abstract m13(): number;
        abstract reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): Matrix4f;
        abstract mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract mapnZnXY(arg0: Matrix4f_): Matrix4f;
        abstract frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): Matrix4f;
        abstract unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
        abstract perspectiveFar(): number;
        abstract perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): Matrix4f;
        abstract scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract normalize3x3(arg0: Matrix3f_): Matrix3f;
        abstract transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): Matrix4f;
        abstract mapnYZnX(arg0: Matrix4f_): Matrix4f;
        abstract orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract m02(): number;
        abstract unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
        abstract mapnXnZnY(arg0: Matrix4f_): Matrix4f;
        abstract project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
        abstract scaleLocal(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract mapnYXZ(arg0: Matrix4f_): Matrix4f;
        abstract rotateLocalZ(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract scale(arg0: number, arg1: Matrix4f_): Matrix4f;
        abstract normalizedPositiveZ(arg0: Vec3f_): Vec3f;
        abstract mapYnXZ(arg0: Matrix4f_): Matrix4f;
        abstract cofactor3x3(arg0: Matrix4f_): Matrix4f;
        abstract scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
        abstract ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): Matrix4f;
        abstract reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): Matrix4f;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract positiveX(arg0: Vec3f_): Vec3f;
        abstract mapXnZnY(arg0: Matrix4f_): Matrix4f;
        abstract testPoint(arg0: number, arg1: number, arg2: number): boolean;
        abstract determinant(): number;
        abstract perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract perspectiveFov(): number;
        abstract scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract mapZYnX(arg0: Matrix4f_): Matrix4f;
        abstract add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract originAffine(arg0: Vec3f_): Vec3f;
        abstract invertOrtho(arg0: Matrix4f_): Matrix4f;
        abstract mapYZX(arg0: Matrix4f_): Matrix4f;
        abstract m03(): number;
        abstract reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract mapnXYnZ(arg0: Matrix4f_): Matrix4f;
        abstract unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
        abstract mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        abstract withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): Matrix4f;
        abstract perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): Matrix4f;
        abstract getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract mapYnZnX(arg0: Matrix4f_): Matrix4f;
        abstract mapnXnYnZ(arg0: Matrix4f_): Matrix4f;
        abstract mapnZnYX(arg0: Matrix4f_): Matrix4f;
        abstract origin(arg0: Vec3f_): Vec3f;
        abstract getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract determinantAffine(): number;
        abstract mapnXZnY(arg0: Matrix4f_): Matrix4f;
        abstract rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): Matrix4f;
        abstract m30(): number;
        abstract project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
        abstract positiveY(arg0: Vec3f_): Vec3f;
        abstract unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
        abstract lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): Matrix4f;
        abstract negateX(arg0: Matrix4f_): Matrix4f;
        abstract rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): Matrix4f;
        abstract getTranslation(arg0: Vec3f_): Vec3f;
        abstract invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): Matrix4f;
        get finite(): boolean
        get affine(): boolean
        readonly PLANE_PX: 1;
        readonly CORNER_PXNYPZ: 4;
        readonly PLANE_NY: 2;
        readonly PLANE_NZ: 4;
        readonly PLANE_PY: 3;
        readonly PLANE_NX: 0;
        readonly PLANE_PZ: 5;
        readonly PROPERTY_TRANSLATION: 8;
        readonly CORNER_PXNYNZ: 1;
        readonly CORNER_PXPYPZ: 7;
        readonly PROPERTY_IDENTITY: 4;
        readonly CORNER_PXPYNZ: 2;
        readonly PROPERTY_PERSPECTIVE: 1;
        readonly PROPERTY_ORTHONORMAL: 16;
        readonly CORNER_NXPYPZ: 6;
        readonly PROPERTY_AFFINE: 2;
        readonly CORNER_NXNYNZ: 0;
        readonly CORNER_NXNYPZ: 5;
        readonly CORNER_NXPYNZ: 3;
    }
    type Matrix4fc_ = Matrix4fc;
    interface RedirectModifier <S> {
        abstract apply(arg0: Internal.CommandContext_<S>): Internal.Collection<S>;
        (arg0: Internal.CommandContext<S>): Internal.Collection_<S>;
    }
    type RedirectModifier_<S> = RedirectModifier<S>;
    class RealmsServer extends Internal.ValueObject {
        constructor()
        clone(): any;
        getWorldName($$0: number): string;
        toServerData($$0: string): Internal.ServerData;
        getDescription(): string;
        updateServerPing($$0: Internal.RealmsServerPlayerList_): void;
        clone(): this;
        setDescription($$0: string): void;
        getMinigameName(): string;
        setName($$0: string): void;
        getName(): string;
        static parse($$0: Internal.JsonObject_): Internal.RealmsServer;
        static parse($$0: string): Internal.RealmsServer;
        cloneSlots($$0: Internal.Map_<number, Internal.RealmsWorldOptions>): Internal.Map<number, Internal.RealmsWorldOptions>;
        get description(): string
        set description($$0: string)
        get minigameName(): string
        set name($$0: string)
        get name(): string
        name: string;
        remoteSubscriptionId: string;
        motd: string;
        players: Internal.List<com.mojang.realmsclient.dto.PlayerInfo>;
        activeSlot: number;
        minigameName: string;
        ownerUUID: string;
        daysLeft: number;
        minigameImage: string;
        slots: Internal.Map<number, Internal.RealmsWorldOptions>;
        minigameId: number;
        id: number;
        worldType: Internal.RealmsServer$WorldType;
        state: Internal.RealmsServer$State;
        expiredTrial: boolean;
        serverPing: Internal.RealmsServerPing;
        owner: string;
        expired: boolean;
    }
    type RealmsServer_ = RealmsServer;
    interface Long2ObjectMap$FastEntrySet <V> extends Internal.ObjectSet<Internal.Long2ObjectMap$Entry<V>> {
        forEach(arg0: Internal.Consumer_<Internal.Long2ObjectMap$Entry<V>>): void;
        of<K>(arg0: K, arg1: K, arg2: K): Internal.ObjectSet<K>;
        abstract isEmpty(): boolean;
        of<K>(arg0: K, arg1: K): Internal.ObjectSet<K>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        abstract addAll(arg0: Internal.Collection_<Internal.Long2ObjectMap$Entry<V>>): boolean;
        abstract add(arg0: Internal.Long2ObjectMap$Entry_<V>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        stream(): Internal.Stream<Internal.Long2ObjectMap$Entry<V>>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        of<K>(): Internal.ObjectSet<K>;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(...arg0: K[]): Internal.ObjectSet<K>;
        abstract clear(): void;
        of<K>(arg0: K): Internal.ObjectSet<K>;
        abstract equals(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<Internal.Long2ObjectMap$Entry<V>>): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        abstract fastIterator(): Internal.ObjectIterator<Internal.Long2ObjectMap$Entry<V>>;
        fastForEach(arg0: Internal.Consumer_<Internal.Long2ObjectMap$Entry<V>>): void;
        parallelStream(): Internal.Stream<Internal.Long2ObjectMap$Entry<V>>;
        get empty(): boolean
    }
    type Long2ObjectMap$FastEntrySet_<V> = Long2ObjectMap$FastEntrySet<V>;
    class GasTankItem extends Internal.Item implements Internal.BotariumFluidItem<Internal.WrappedItemFluidContainer> {
        constructor(properties: Internal.Item$Properties_, tankSize: number, distributionAmount: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getFluidContainer(arg0: Internal.ItemStack_): Internal.ItemFluidContainer;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        distributeSequential(from: Internal.ItemStackHolder_, container: Internal.FluidHolder_, inventory: Internal.Inventory_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type GasTankItem_ = GasTankItem;
    interface KeyAccess {
        abstract setDisplayName(arg0: Internal.LazyLoadedValue_<net.minecraft.network.chat.Component>): void;
        set displayName(arg0: Internal.LazyLoadedValue_<net.minecraft.network.chat.Component>)
        (arg0: Internal.LazyLoadedValue<net.minecraft.network.chat.Component>): void;
    }
    type KeyAccess_ = KeyAccess;
    interface DragonPhaseInstance {
        abstract doClientTick(): void;
        abstract onHurt(arg0: DamageSource_, arg1: number): number;
        abstract isSitting(): boolean;
        abstract getFlyTargetLocation(): Vec3d;
        abstract end(): void;
        abstract getFlySpeed(): number;
        abstract getPhase(): Internal.EnderDragonPhase<Internal.DragonPhaseInstance>;
        abstract getTurnSpeed(): number;
        abstract onCrystalDestroyed(arg0: Internal.EndCrystal_, arg1: BlockPos_, arg2: DamageSource_, arg3: Internal.Player_): void;
        abstract begin(): void;
        abstract doServerTick(): void;
        get sitting(): boolean
        get flyTargetLocation(): Vec3d
        get flySpeed(): number
        get phase(): Internal.EnderDragonPhase<Internal.DragonPhaseInstance>
        get turnSpeed(): number
    }
    type DragonPhaseInstance_ = DragonPhaseInstance;
    class PiglinArmPose extends Internal.Enum<Internal.PiglinArmPose> {
        static valueOf($$0: string): Internal.PiglinArmPose;
        static values(): Internal.PiglinArmPose[];
        static readonly CROSSBOW_CHARGE: Internal.PiglinArmPose;
        static readonly DEFAULT: Internal.PiglinArmPose;
        static readonly ADMIRING_ITEM: Internal.PiglinArmPose;
        static readonly DANCING: Internal.PiglinArmPose;
        static readonly ATTACKING_WITH_MELEE_WEAPON: Internal.PiglinArmPose;
        static readonly CROSSBOW_HOLD: Internal.PiglinArmPose;
    }
    type PiglinArmPose_ = "admiring_item" | "dancing" | "crossbow_hold" | "crossbow_charge" | PiglinArmPose | "default" | "attacking_with_melee_weapon";
    interface IHudItem {
        abstract renderHud(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Player_, arg3: Internal.InteractionHand_, arg4: Internal.Direction_, arg5: Vec3d_): boolean;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.Player, arg3: Internal.InteractionHand, arg4: Internal.Direction, arg5: Vec3d): boolean;
    }
    type IHudItem_ = IHudItem;
    interface IMultiBlockEntityContainer$Inventory extends Internal.IMultiBlockEntityContainer {
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        abstract getMaxWidth(): number;
        abstract removeController(arg0: boolean): void;
        abstract getControllerBE<T extends Internal.BlockEntity & Internal.IMultiBlockEntityContainer>(): T;
        abstract getWidth(): number;
        abstract isController(): boolean;
        abstract setController(arg0: BlockPos_): void;
        hasInventory(): boolean;
        setExtraData(data: any): void;
        modifyExtraData(data: any): any;
        abstract getController(): BlockPos;
        abstract getLastKnownPos(): BlockPos;
        abstract preventConnectivityUpdate(): void;
        abstract notifyMultiUpdated(): void;
        getExtraData(): any;
        abstract getMainConnectionAxis(): Internal.Direction$Axis;
        abstract setHeight(arg0: number): void;
        abstract setWidth(arg0: number): void;
        abstract getHeight(): number;
        abstract getMaxLength(arg0: Internal.Direction$Axis_, arg1: number): number;
        get maxWidth(): number
        get controllerBE(): T
        get width(): number
        get controller(): boolean
        set controller(arg0: BlockPos_)
        set extraData(data: any)
        get controller(): BlockPos
        get lastKnownPos(): BlockPos
        get extraData(): any
        get mainConnectionAxis(): Internal.Direction$Axis
        set height(arg0: number)
        set width(arg0: number)
        get height(): number
    }
    type IMultiBlockEntityContainer$Inventory_ = IMultiBlockEntityContainer$Inventory;
    interface PlayerEvents$PlayerLoggedInOrOut {
        abstract handleConnection(arg0: Internal.Player_): void;
        (arg0: Internal.Player): void;
    }
    type PlayerEvents$PlayerLoggedInOrOut_ = PlayerEvents$PlayerLoggedInOrOut;
    abstract class GuiBook extends Internal.Screen {
        constructor(book: Internal.Book_, title: net.minecraft.network.chat.Component_)
        addBookmarkButtons(): void;
        charTyped($$0: string, $$1: number): boolean;
        getRelativeX(absX: number): number;
        isFocused(): boolean;
        displayLexiconGui(gui: Internal.GuiBook_, push: boolean): void;
        redirect$hma000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        getMinecraft(): Internal.Minecraft;
        setFocused($$0: boolean): void;
        getTabOrderGroup(): number;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        getRelativeY(absY: number): number;
        isMouseInRelativeRange(absMx: number, absMy: number, x: number, y: number, w: number, h: number): boolean;
        static drawLock(graphics: Internal.GuiGraphics_, book: Internal.Book_, x: number, y: number): void;
        drawProgressBar(graphics: Internal.GuiGraphics_, book: Internal.Book_, mouseX: number, mouseY: number, filter: Internal.Predicate_<Internal.BookEntry>): void;
        static drawPageFiller(graphics: Internal.GuiGraphics_, book: Internal.Book_): void;
        addRenderableWidget<T extends Internal.GuiEventListener & Internal.Renderable & Internal.NarratableEntry>(drawableElement: T): T;
        handleButtonArrow(button: Internal.Button_): void;
        setTooltipStack(stack: Internal.ItemStack_): void;
        removeDrawablesIf(pred: Internal.Predicate_<Internal.Renderable>): void;
        method_25426(): void;
        setTooltip(...strings: net.minecraft.network.chat.Component_[]): void;
        mouseClickedScaled(mouseX: number, mouseY: number, mouseButton: number): boolean;
        canBeOpened(): boolean;
        static getExtensions(screen: Internal.Screen_): Internal.ScreenExtensions;
        static openWebLink(prevScreen: Internal.Screen_, address: string): void;
        canSeePageButton(left: boolean): boolean;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        static drawFromTexture(graphics: Internal.GuiGraphics_, book: Internal.Book_, x: number, y: number, u: number, v: number, w: number, h: number): void;
        mouseMoved($$0: number, $$1: number): void;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        removeDrawablesIn(coll: Internal.Collection_<any>): void;
        drawCenteredStringNoShadow(graphics: Internal.GuiGraphics_, s: Internal.FormattedCharSequence_, x: number, y: number, color: number): void;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        drawCenteredStringNoShadow(graphics: Internal.GuiGraphics_, s: string, x: number, y: number, color: number): void;
        bookmarkThis(): void;
        static drawPageFiller(graphics: Internal.GuiGraphics_, book: Internal.Book_, x: number, y: number): void;
        canSeeBackButton(): boolean;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        onFirstOpened(): void;
        getSpread(): number;
        static drawSeparator(graphics: Internal.GuiGraphics_, book: Internal.Book_, x: number, y: number): void;
        static drawMarking(graphics: Internal.GuiGraphics_, book: Internal.Book_, x: number, y: number, rand: number, state: Internal.EntryDisplayState_): void;
        static playBookFlipSound(book: Internal.Book_): void;
        setTooltip(strings: Internal.List_<net.minecraft.network.chat.Component>): void;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        handleButtonBookmark(button: Internal.Button_): void;
        get focused(): boolean
        get minecraft(): Internal.Minecraft
        set focused($$0: boolean)
        get tabOrderGroup(): number
        set tooltipStack(stack: Internal.ItemStack_)
        set tooltip(...strings: net.minecraft.network.chat.Component_[])
        get currentFocusPath(): Internal.ComponentPath
        get spread(): number
        set tooltip(strings: Internal.List_<net.minecraft.network.chat.Component>)
        bookLeft: number;
        static readonly PAGE_HEIGHT: 156;
        ticksInBook: number;
        static readonly MAX_BOOKMARKS: 10;
        static readonly RIGHT_PAGE_X: 141;
        static readonly PAGE_WIDTH: 116;
        maxScale: number;
        static readonly LEFT_PAGE_X: 15;
        static readonly FULL_HEIGHT: 180;
        readonly book: Internal.Book;
        static readonly TEXT_LINE_HEIGHT: 9;
        static readonly FULL_WIDTH: 272;
        static readonly TOP_PADDING: 18;
        bookTop: number;
    }
    type GuiBook_ = GuiBook;
    abstract class BlockEntityAbstractImpetus extends Internal.HexBlockEntity implements Internal.IPeripheralTileDucky, Internal.WorldlyContainer {
        constructor(pType: Internal.BlockEntityType_<any>, pWorldPosition: BlockPos_, pBlockState: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        static tryClear($$0: any): void;
        postNoExits(pos: BlockPos_): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        insertMedia(stack: Internal.ItemStack_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        getPigment(): Internal.FrozenPigment;
        postPrint(printDisplay: net.minecraft.network.chat.Component_): void;
        getContainerSize(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        applyScryingLensOverlay(lines: Internal.List_<com.mojang.datafixers.util.Pair<Internal.ItemStack, net.minecraft.network.chat.Component>>, state: Internal.BlockState_, pos: BlockPos_, observer: Internal.Player_, world: Internal.Level_, hitFace: Internal.Direction_): void;
        getSlotsForFace(var1: Internal.Direction_): number[];
        setItem(index: number, stack: Internal.ItemStack_): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        removeItemNoUpdate(index: number): Internal.ItemStack;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        extractMediaFromInsertedItem(stack: Internal.ItemStack_, simulate: boolean): number;
        getPeripheral(side: Internal.Direction_): Internal.IPeripheral;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getItem(index: number): Internal.ItemStack;
        canTakeItemThroughFace(var1: number, var2: Internal.ItemStack_, var3: Internal.Direction_): boolean;
        tickExecution(): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        getStartDirection(): Internal.Direction;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setInfiniteMedia(): void;
        isEmpty(): boolean;
        canPlaceItem(index: number, stack: Internal.ItemStack_): boolean;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        clearDisplay(): void;
        setMedia(media: number): void;
        getMedia(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        canPlaceItemThroughFace(index: number, stack: Internal.ItemStack_, dir: Internal.Direction_): boolean;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        endExecution(): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        postMishap(mishapDisplay: net.minecraft.network.chat.Component_): void;
        getHeight(): number;
        startExecution(player: Internal.ServerPlayer_): void;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        postDisplay(error: net.minecraft.network.chat.Component_, display: Internal.ItemStack_): void;
        setPigment(pigment: Internal.FrozenPigment_): Internal.FrozenPigment;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getExecutionState(): Internal.CircleExecutionState;
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getDisplayMsg(): net.minecraft.network.chat.Component;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        remainingMediaCapacity(): number;
        handler$dee000$hextweaks$sendToPlayer(printDisplay: net.minecraft.network.chat.Component_, ci: Internal.CallbackInfo_): void;
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get pigment(): Internal.FrozenPigment
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        get startDirection(): Internal.Direction
        set transferCooldown(currentTime: number)
        get empty(): boolean
        set media(media: number)
        get media(): number
        get height(): number
        set pigment(pigment: Internal.FrozenPigment_)
        get allItems(): Internal.List<Internal.ItemStack>
        get executionState(): Internal.CircleExecutionState
        get displayMsg(): net.minecraft.network.chat.Component
        get mutable(): boolean
        static readonly TAG_PIGMENT: "pigment";
        static readonly TAG_ERROR_DISPLAY: "errorDisplay";
        static readonly TAG_MEDIA: "media";
        static readonly TAG_EXECUTION_STATE: "executor";
        static readonly TAG_ERROR_MSG: "errorMsg";
    }
    type BlockEntityAbstractImpetus_ = BlockEntityAbstractImpetus;
    interface DrawableWidget$DrawableWidgetConsumer {
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.GuiGraphics, arg1: number, arg2: number, arg3: number): void;
    }
    type DrawableWidget$DrawableWidgetConsumer_ = DrawableWidget$DrawableWidgetConsumer;
    class InstrumentItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_, $$1: Internal.TagKey_<Internal.Instrument>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static create($$0: Internal.Item_, $$1: Internal.Holder_<Internal.Instrument>): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static setRandom($$0: Internal.ItemStack_, $$1: Internal.TagKey_<Internal.Instrument>, $$2: Internal.RandomSource_): void;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type InstrumentItem_ = InstrumentItem;
    class ClientboundSoundPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Holder_<Internal.SoundEvent>, $$1: Internal.SoundSource_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        getX(): number;
        handle(arg0: Internal.PacketListener_): void;
        getVolume(): number;
        getY(): number;
        getSound(): Internal.Holder<Internal.SoundEvent>;
        getZ(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSource(): Internal.SoundSource;
        getSeed(): number;
        getPitch(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get x(): number
        get volume(): number
        get y(): number
        get sound(): Internal.Holder<Internal.SoundEvent>
        get z(): number
        get source(): Internal.SoundSource
        get seed(): number
        get pitch(): number
        get skippable(): boolean
        static readonly LOCATION_ACCURACY: 8.0;
    }
    type ClientboundSoundPacket_ = ClientboundSoundPacket;
    abstract class PartRequirement {
        constructor(weight: number)
        static read(buffer: Internal.FriendlyByteBuf_): Internal.PartRequirement;
        abstract matches(arg0: Internal.Item_): boolean;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        abstract nameForMaterial(arg0: Internal.MaterialVariantId_): net.minecraft.network.chat.Component;
        static ofStat(statsId: Internal.MaterialStatsId_, weight: number): Internal.PartRequirement;
        static ofPart(part: Internal.IToolPart_, weight: number): Internal.PartRequirement;
        abstract serialize(): Internal.JsonObject;
        abstract canUseMaterial(arg0: Internal.MaterialVariantId_): boolean;
        abstract getStatType(): Internal.MaterialStatsId;
        getWeight(): number;
        abstract getPart(): Internal.IToolPart;
        get statType(): Internal.MaterialStatsId
        get weight(): number
        get part(): Internal.IToolPart
        static readonly SERIALIZER: Internal.PartRequirement$Serializer;
    }
    type PartRequirement_ = PartRequirement;
    class SkyStoneTankBlock extends Internal.AEBaseEntityBlock<any> {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SkyStoneTankBlock_ = SkyStoneTankBlock;
    class Display$BlockDisplay$BlockRenderState extends Internal.Record {
        constructor($$0: Internal.BlockState_)
        blockState(): Internal.BlockState;
    }
    type Display$BlockDisplay$BlockRenderState_ = Display$BlockDisplay$BlockRenderState;
    interface IHasTrackCasing {
        isAlternate(): boolean;
        isAlternate(world: Internal.Level_, pos: BlockPos_): boolean;
        setTrackCasing(world: Internal.Level_, pos: BlockPos_, trackCasing: Internal.SlabBlock_): void;
        setAlternateModel(world: Internal.Level_, pos: BlockPos_, useAlternateModel: boolean): boolean;
        getTrackCasing(world: Internal.Level_, pos: BlockPos_): Internal.SlabBlock;
        abstract getTrackCasing(): Internal.SlabBlock;
        abstract setTrackCasing(arg0: Internal.SlabBlock_): void;
        setAlternate(alternate: boolean): void;
        get alternate(): boolean
        get trackCasing(): Internal.SlabBlock
        set trackCasing(arg0: Internal.SlabBlock_)
        set alternate(alternate: boolean)
    }
    type IHasTrackCasing_ = IHasTrackCasing;
    class WireConnectResult extends Internal.Enum<Internal.WireConnectResult> {
        getMessage(): net.minecraft.network.chat.Component;
        isLinked(): boolean;
        static valueOf(name: string): Internal.WireConnectResult;
        static getLink(in_: boolean, out: boolean): Internal.WireConnectResult;
        static getConnect(in_: boolean, out: boolean): Internal.WireConnectResult;
        isConnect(): boolean;
        static values(): Internal.WireConnectResult[];
        get message(): net.minecraft.network.chat.Component
        get linked(): boolean
        get connect(): boolean
        static readonly LINKED: Internal.WireConnectResult;
        static readonly LONG: Internal.WireConnectResult;
        static readonly LINKED_IN: Internal.WireConnectResult;
        static readonly INVALID: Internal.WireConnectResult;
        static readonly REQUIRES_HIGH_CURRENT: Internal.WireConnectResult;
        static readonly CONNECT_OUT: Internal.WireConnectResult;
        static readonly COUNT: Internal.WireConnectResult;
        static readonly CONNECT_IN: Internal.WireConnectResult;
        static readonly OBSTRUCTED: Internal.WireConnectResult;
        static readonly EXISTS: Internal.WireConnectResult;
        static readonly CONNECT: Internal.WireConnectResult;
        static readonly NO_CONNECTION: Internal.WireConnectResult;
        static readonly LINKED_OUT: Internal.WireConnectResult;
        static readonly REMOVED: Internal.WireConnectResult;
    }
    type WireConnectResult_ = WireConnectResult | "removed" | "obstructed" | "count" | "exists" | "requires_high_current" | "invalid" | "linked_in" | "connect" | "long" | "no_connection" | "linked" | "connect_out" | "connect_in" | "linked_out";
    class ConcurrentHashMap$KeySetView <K, V> extends Internal.ConcurrentHashMap$CollectionView<K, V, K> implements Internal.Set<K>, Internal.Serializable {
        spliterator(): Internal.Spliterator<K>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        getMap(): Internal.ConcurrentHashMap<any, any>;
        abstract toArray<T>(arg0: T[]): T[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        parallelStream(): Internal.Stream<K>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        iterator(): Internal.Iterator<K>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        getMappedValue(): V;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        stream(): Internal.Stream<K>;
        get map(): Internal.ConcurrentHashMap<any, any>
        get mappedValue(): V
    }
    type ConcurrentHashMap$KeySetView_<K, V> = ConcurrentHashMap$KeySetView<K, V>;
    class MediumTripleWheelBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MediumTripleWheelBogeyBlock_ = MediumTripleWheelBogeyBlock;
    class PiglinSpecificSensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type PiglinSpecificSensor_ = PiglinSpecificSensor;
    class StandingCanvasSignBlock extends Internal.StandingSignBlock implements Internal.CanvasSign {
        constructor(backgroundColor: Internal.DyeColor_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        isDarkBackground(): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBackgroundColor(): Internal.DyeColor;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get darkBackground(): boolean
        get mod(): string
        set destroySpeed(v: number)
        get backgroundColor(): Internal.DyeColor
    }
    type StandingCanvasSignBlock_ = StandingCanvasSignBlock;
    class PBRType extends Internal.Enum<Internal.PBRType> {
        appendSuffix(path: string): string;
        static values(): Internal.PBRType[];
        static removeSuffix(path: string): string;
        static valueOf(name: string): Internal.PBRType;
        getDefaultValue(): number;
        getSuffix(): string;
        static fromFileLocation(location: string): Internal.PBRType;
        get defaultValue(): number
        get suffix(): string
        static readonly SPECULAR: Internal.PBRType;
        static readonly NORMAL: Internal.PBRType;
    }
    type PBRType_ = "normal" | PBRType | "specular";
    interface AccessorCompositeRenderType {
        abstract hex$state(): Internal.RenderType$CompositeState;
        (): Internal.RenderType$CompositeState_;
    }
    type AccessorCompositeRenderType_ = AccessorCompositeRenderType;
    class SavedTick <T> extends Internal.Record {
        constructor($$0: T, $$1: BlockPos_, $$2: number, $$3: Internal.TickPriority_)
        unpack($$0: number, $$1: number): Internal.ScheduledTick<T>;
        static loadTickList<T>($$0: Internal.ListTag_, $$1: Internal.Function_<string, Internal.Optional<T>>, $$2: Internal.ChunkPos_, $$3: Internal.Consumer_<Internal.SavedTick<T>>): void;
        delay(): number;
        pos(): BlockPos;
        save($$0: Internal.Function_<T, string>): Internal.CompoundTag;
        static saveTick<T>($$0: Internal.ScheduledTick_<T>, $$1: Internal.Function_<T, string>, $$2: number): Internal.CompoundTag;
        type(): T;
        static probe<T>($$0: T, $$1: BlockPos_): Internal.SavedTick<T>;
        priority(): Internal.TickPriority;
        static loadTick<T>($$0: Internal.CompoundTag_, $$1: Internal.Function_<string, Internal.Optional<T>>): Internal.Optional<Internal.SavedTick<T>>;
        static readonly UNIQUE_TICK_HASH: Internal.Hash$Strategy<Internal.SavedTick<any>>;
    }
    type SavedTick_<T> = SavedTick<T>;
    interface LevelResourceAccessor {
        forgeconfigapiport$create(string: string): Internal.LevelResource;
    }
    type LevelResourceAccessor_ = LevelResourceAccessor;
    class SpawnData$CustomSpawnRules extends Internal.Record {
        constructor($$0: Internal.InclusiveRange_<number>, $$1: Internal.InclusiveRange_<number>)
        skyLightLimit(): Internal.InclusiveRange<number>;
        blockLightLimit(): Internal.InclusiveRange<number>;
        static readonly CODEC: Internal.Codec<Internal.SpawnData$CustomSpawnRules>;
    }
    type SpawnData$CustomSpawnRules_ = SpawnData$CustomSpawnRules;
    class Aquifer$FluidStatus {
        constructor($$0: number, $$1: Internal.BlockState_)
        at($$0: number): Internal.BlockState;
    }
    type Aquifer$FluidStatus_ = Aquifer$FluidStatus;
    class FoodCakeBlock extends Internal.CakeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, food: Internal.FoodProperties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FoodCakeBlock_ = FoodCakeBlock;
    class ClientboundEntityEventPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Entity_, $$1: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getEventId(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntity($$0: Internal.Level_): Internal.Entity;
        isSkippable(): boolean;
        get eventId(): number
        get skippable(): boolean
    }
    type ClientboundEntityEventPacket_ = ClientboundEntityEventPacket;
    interface Long2ObjectSortedMap <V> extends Internal.SortedMap<number, V>, Internal.Long2ObjectMap<V> {
        abstract subMap(arg0: number, arg1: number): this;
        abstract containsValue(arg0: any): boolean;
        remove(arg0: number): V;
        sequencedEntrySet(): Internal.SequencedSet<Internal.Map$Entry<number, V>>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        firstEntry(): Internal.Map$Entry<number, V>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        sequencedValues(): Internal.SequencedCollection<V>;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        values(): Internal.Collection<any>;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        abstract defaultReturnValue(): V;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        abstract tailMap(arg0: number): this;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        lastEntry(): Internal.Map$Entry<number, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        of<K, V>(): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        abstract headMap(arg0: number): this;
        /**
         * @deprecated
        */
        firstKey(): any;
        /**
         * @deprecated
        */
        tailMap(arg0: number): this;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        abstract long2ObjectEntrySet(): Internal.ObjectSortedSet<Internal.Long2ObjectMap$Entry<V>>;
        put(arg0: number, arg1: V): V;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        abstract comparator(): Internal.LongComparator;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        putFirst(arg0: number, arg1: V): V;
        abstract lastLongKey(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        abstract size(): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSortedSet<Internal.Map$Entry<number, V>>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        replace(arg0: number, arg1: V): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        reversed(): Internal.SortedMap<number, V>;
        replace(arg0: number, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        /**
         * @deprecated
        */
        lastKey(): any;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        computeIfAbsent(arg0: number, arg1: Internal.LongFunction_<V>): V;
        /**
         * @deprecated
        */
        subMap(arg0: any, arg1: any): Internal.SortedMap<any, any>;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        apply(arg0: number): V;
        abstract putAll(arg0: Internal.Map_<number, V>): void;
        abstract containsKey(arg0: number): boolean;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        abstract firstLongKey(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        sequencedKeySet(): Internal.SequencedSet<number>;
        /**
         * @deprecated
        */
        headMap(arg0: number): this;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        remove(arg0: number, arg1: any): boolean;
        abstract defaultReturnValue(arg0: V): void;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        /**
         * @deprecated
        */
        computeIfAbsentPartial(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        pollFirstEntry(): Internal.Map$Entry<number, V>;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        computeIfAbsent(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        apply(arg0: number): V;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        putLast(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        subMap(arg0: number, arg1: number): this;
        /**
         * @deprecated
        */
        tailMap(arg0: any): Internal.SortedMap<any, any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        headMap(arg0: any): Internal.SortedMap<any, any>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        abstract get(arg0: number): V;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        pollLastEntry(): Internal.Map$Entry<number, V>;
        abstract keySet(): Internal.LongSortedSet;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        abstract equals(arg0: any): boolean;
        putIfAbsent(arg0: number, arg1: V): V;
        get empty(): boolean
    }
    type Long2ObjectSortedMap_<V> = Long2ObjectSortedMap<V>;
    class FoliagePlacerType <P extends Internal.FoliagePlacer> {
        constructor($$0: Internal.Codec_<P>)
        codec(): Internal.Codec<P>;
        static readonly MEGA_JUNGLE_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.MegaJungleFoliagePlacer>;
        static readonly FANCY_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.FancyFoliagePlacer>;
        static readonly RANDOM_SPREAD_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.RandomSpreadFoliagePlacer>;
        static readonly CHERRY_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.CherryFoliagePlacer>;
        static readonly DARK_OAK_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.DarkOakFoliagePlacer>;
        static readonly SPRUCE_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.SpruceFoliagePlacer>;
        static readonly BLOB_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.BlobFoliagePlacer>;
        static readonly PINE_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.PineFoliagePlacer>;
        static readonly MEGA_PINE_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.MegaPineFoliagePlacer>;
        static readonly ACACIA_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.AcaciaFoliagePlacer>;
        static readonly BUSH_FOLIAGE_PLACER: Internal.FoliagePlacerType<Internal.BushFoliagePlacer>;
    }
    type FoliagePlacerType_<P extends Internal.FoliagePlacer> = FoliagePlacerType<P> | Special.FoliagePlacerType;
    interface INamedIconOptions {
        abstract getIcon(): Internal.AllIcons;
        abstract getTranslationKey(): string;
        get icon(): Internal.AllIcons
        get translationKey(): string
    }
    type INamedIconOptions_ = INamedIconOptions;
    class EventObject implements Internal.Serializable {
        constructor(arg0: any)
        getSource(): any;
        get source(): any
    }
    type EventObject_ = EventObject;
    interface CustomHitSoundItem {
        abstract playHitSound(arg0: Internal.Player_): void;
        (arg0: Internal.Player): void;
    }
    type CustomHitSoundItem_ = CustomHitSoundItem;
    class ControlsBlock extends Internal.HorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(p_54120_: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly VIRTUAL: Internal.BooleanProperty;
        static readonly OPEN: Internal.BooleanProperty;
    }
    type ControlsBlock_ = ControlsBlock;
    class EnergizerBlockItem extends Internal.BlockItem implements Internal.BotariumEnergyItem<Internal.WrappedItemEnergyContainer> {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getEnergyStorage(holder: Internal.ItemStack_): Internal.WrappedItemEnergyContainer;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnergizerBlockItem_ = EnergizerBlockItem;
    interface NarratableEntry extends Internal.NarrationSupplier, Internal.TabOrderedElement {
        abstract narrationPriority(): Internal.NarratableEntry$NarrationPriority;
        abstract updateNarration(arg0: Internal.NarrationElementOutput_): void;
        isActive(): boolean;
        getTabOrderGroup(): number;
        get active(): boolean
        get tabOrderGroup(): number
    }
    type NarratableEntry_ = NarratableEntry;
    class RecordItem extends Internal.Item implements Internal.RecordItemAccessor {
        constructor($$0: number, $$1: Internal.SoundEvent_, $$2: Internal.Item$Properties_, $$3: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getSound(): Internal.SoundEvent;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getByName(): Internal.Map<Internal.SoundEvent, Internal.RecordItem>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static getByName$sophisticatedbackpacks_$md$fca01f$0(): Internal.Map<any, any>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        static getBySound($$0: Internal.SoundEvent_): Internal.RecordItem;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDisplayName(): Internal.MutableComponent;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getLengthInTicks(): number;
        emi(amount: number): Internal.EmiStack;
        getAnalogOutput(): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get sound(): Internal.SoundEvent
        get byName(): Internal.Map<Internal.SoundEvent, Internal.RecordItem>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get byName$sophisticatedbackpacks_$md$fca01f$0(): Internal.Map<any, any>
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get displayName(): Internal.MutableComponent
        get lengthInTicks(): number
        get analogOutput(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly BY_NAME: {[key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.MusicDiscItemBOP, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem, [key: Internal.SoundEvent]: Internal.RecordItem};
    }
    type RecordItem_ = RecordItem;
    class HangingFleshTendonFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(p_67375_: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static placeFleshTendonColumn(p_67377_: Internal.LevelAccessor_, p_67378_: Internal.RandomSource_, p_67379_: Internal.BlockPos$MutableBlockPos_, p_67380_: number): void;
    }
    type HangingFleshTendonFeature_ = HangingFleshTendonFeature;
    interface IWireNode {
        dropWires(world: Internal.Level_, player: Internal.Player_, dropItems: boolean): void;
        abstract setNetwork(arg0: number, arg1: Internal.EnergyNetwork_): void;
        dropWires(world: Internal.Level_, dropItems: boolean): void;
        readNodeWireType(nbt: Internal.CompoundTag_, index: number): Internal.WireType;
        removeNode(node: Internal.LocalNode_, dropWire: boolean): void;
        isNodeIndeciesConnected(in_: number, other: number): boolean;
        validateLocalNodes(localNodes: Internal.LocalNode_[]): boolean;
        dropWire(world: Internal.Level_, pos: BlockPos_, stack: Internal.ItemStack_): void;
        readNodeOtherIndex(nbt: Internal.CompoundTag_, index: number): number;
        getTypeOfConnection(level: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireType;
        abstract removeNode(arg0: number, arg1: boolean): void;
        getNodePos(index: number): BlockPos;
        getNbtNode(nbt: Internal.CompoundTag_, index: number): Internal.CompoundTag;
        abstract getMaxWireLength(): number;
        dropWire(world: Internal.Level_, node: Internal.LocalNode_): void;
        abstract getPos(): BlockPos;
        abstract getNetwork(arg0: number): Internal.EnergyNetwork;
        getNodeType(index: number): Internal.WireType;
        abstract invalidateNodeCache(): void;
        getNodeCount(): number;
        getOtherNodeIndex(index: number): number;
        isNodeInput(index: number): boolean;
        abstract getConnectorType(): Internal.ConnectorType;
        abstract getLocalNode(arg0: number): Internal.LocalNode;
        connect(world: Internal.Level_, pos1: BlockPos_, node1: number, pos2: BlockPos_, node2: number, type: Internal.WireType_): Internal.WireConnectResult;
        removeNode(index: number): void;
        getConnectionTo(pos: BlockPos_): Internal.LocalNode;
        abstract setNode(arg0: number, arg1: number, arg2: BlockPos_, arg3: Internal.WireType_): void;
        isNodeOutput(node: number): boolean;
        disconnect(world: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireConnectResult;
        abstract getWireNode(arg0: number): this;
        isNetworkValid(node: number): boolean;
        hasAnyConnection(): boolean;
        removeNode(node: Internal.LocalNode_): void;
        hasConnectionTo(pos: BlockPos_): boolean;
        getWireNode(level: Internal.Level_, pos: BlockPos_): this;
        readNodeBlockPos(nbt: Internal.CompoundTag_, index: number, origin: BlockPos_): BlockPos;
        getAvailableNode(pos: Vec3d_): number;
        awakeNetwork(world: Internal.Level_): boolean;
        handleWireCache(level: Internal.Level_, toDrop: Internal.Set_<Internal.LocalNode>): void;
        hasConnection(index: number): boolean;
        convertOldNbt(nbt: Internal.CompoundTag_): void;
        getWireNodeFrom(index: number, obj: Internal.IWireNode_, localNodes: Internal.LocalNode_[], nodeCache: Internal.IWireNode_[], level: Internal.Level_): this;
        disconnectWires(): void;
        abstract getNodeOffset(arg0: number): Vec3d;
        getAvailableNode(): number;
        get maxWireLength(): number
        get pos(): BlockPos
        get nodeCount(): number
        get connectorType(): Internal.ConnectorType
        get availableNode(): number
    }
    type IWireNode_ = IWireNode;
    class JigsawBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getJoint(): Internal.JigsawBlockEntity$JointType;
        getName(): ResourceLocation;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setPool($$0: Internal.ResourceKey_<Internal.StructureTemplatePool>): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        generate($$0: Internal.ServerLevel_, $$1: number, $$2: boolean): void;
        setTarget($$0: ResourceLocation_): void;
        getFinalState(): string;
        getUpdatePacket(): Internal.Packet<any>;
        setJoint($$0: Internal.JigsawBlockEntity$JointType_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getTarget(): ResourceLocation;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        setName($$0: ResourceLocation_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPool(): Internal.ResourceKey<Internal.StructureTemplatePool>;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setFinalState($$0: string): void;
        get joint(): Internal.JigsawBlockEntity$JointType
        get name(): ResourceLocation
        set pool($$0: Internal.ResourceKey_<Internal.StructureTemplatePool>)
        set target($$0: ResourceLocation_)
        get finalState(): string
        get updatePacket(): Internal.Packet<any>
        set joint($$0: Internal.JigsawBlockEntity$JointType_)
        get target(): ResourceLocation
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        set name($$0: ResourceLocation_)
        get pool(): Internal.ResourceKey<Internal.StructureTemplatePool>
        set finalState($$0: string)
        static readonly NAME: "name";
        static readonly POOL: "pool";
        static readonly JOINT: "joint";
        static readonly TARGET: "target";
        static readonly FINAL_STATE: "final_state";
    }
    type JigsawBlockEntity_ = JigsawBlockEntity;
    interface HeadedModel {
        abstract getHead(): Internal.ModelPart;
        get head(): Internal.ModelPart
        (): Internal.ModelPart_;
    }
    type HeadedModel_ = HeadedModel;
    abstract class ImmutableCollection$Builder <E> {
        abstract build(): Internal.ImmutableCollection<E>;
        add(...arg0: E[]): this;
        addAll(arg0: Internal.Iterable_<E>): this;
        abstract add(arg0: E): this;
        addAll(arg0: Internal.Iterator_<E>): this;
    }
    type ImmutableCollection$Builder_<E> = ImmutableCollection$Builder<E>;
    interface FastMapStateHolder <S> {
        abstract setStateMap(arg0: Internal.FastMap_<S>): void;
        abstract setStateIndex(arg0: number): void;
        abstract setNeighborTable(arg0: Internal.Table_<Internal.Property<any>, Internal.Comparable<any>, S>): void;
        abstract getStateMap(): Internal.FastMap<S>;
        abstract replacePropertyMap(arg0: Internal.ImmutableMap_<Internal.Property<any>, Internal.Comparable<any>>): void;
        abstract getVanillaPropertyMap(): Internal.ImmutableMap<Internal.Property<any>, Internal.Comparable<any>>;
        abstract getStateIndex(): number;
        abstract getNeighborTable(): Internal.Table<Internal.Property<any>, Internal.Comparable<any>, S>;
        set stateMap(arg0: Internal.FastMap_<S>)
        set stateIndex(arg0: number)
        set neighborTable(arg0: Internal.Table_<Internal.Property<any>, Internal.Comparable<any>, S>)
        get stateMap(): Internal.FastMap<S>
        get vanillaPropertyMap(): Internal.ImmutableMap<Internal.Property<any>, Internal.Comparable<any>>
        get stateIndex(): number
        get neighborTable(): Internal.Table<Internal.Property<any>, Internal.Comparable<any>, S>
    }
    type FastMapStateHolder_<S> = FastMapStateHolder<S>;
    class SpruceFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_, $$2: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.SpruceFoliagePlacer>;
    }
    type SpruceFoliagePlacer_ = SpruceFoliagePlacer;
    class TickingRequest extends Internal.Record {
        constructor(minTickRate: number, maxTickRate: number, isSleeping: boolean, canBeAlerted: boolean)
        constructor(tickRates: any_, isSleeping: boolean, canBeAlerted: boolean)
        constructor(minTickRate: number, maxTickRate: number, isSleeping: boolean, canBeAlerted: boolean, initialTickRate: number)
        isSleeping(): boolean;
        canBeAlerted(): boolean;
        minTickRate(): number;
        initialTickRate(): number;
        maxTickRate(): number;
        get sleeping(): boolean
    }
    type TickingRequest_ = TickingRequest;
    class SuspiciousStewItem extends Internal.Item implements Internal.SuspiciousStewItemAccessor {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static create$listPotionEffects(stack: Internal.ItemStack_, output: Internal.Consumer_<Internal.MobEffectInstance>): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static listPotionEffects$create_$md$fca01f$0(arg0: Internal.ItemStack_, arg1: Internal.Consumer_<any>): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static saveMobEffect($$0: Internal.ItemStack_, $$1: Internal.MobEffect_, $$2: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly EFFECTS_TAG: "Effects";
        static readonly EFFECT_DURATION_TAG: "EffectDuration";
        static readonly DEFAULT_DURATION: 160;
        static readonly EFFECT_ID_TAG: "EffectId";
    }
    type SuspiciousStewItem_ = SuspiciousStewItem;
    interface SpriteFinderImpl$SpriteFinderAccess {
        abstract fabric_spriteFinder(): Internal.SpriteFinderImpl;
        (): Internal.SpriteFinderImpl_;
    }
    type SpriteFinderImpl$SpriteFinderAccess_ = SpriteFinderImpl$SpriteFinderAccess;
    class ClientboundTeleportEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_)
        getX(): number;
        handle(arg0: Internal.PacketListener_): void;
        getY(): number;
        getZ(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getxRot(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getyRot(): number;
        isOnGround(): boolean;
        isSkippable(): boolean;
        getId(): number;
        get x(): number
        get y(): number
        get z(): number
        get xRot(): number
        get yRot(): number
        get onGround(): boolean
        get skippable(): boolean
        get id(): number
    }
    type ClientboundTeleportEntityPacket_ = ClientboundTeleportEntityPacket;
    interface ModelPart$Visitor {
        abstract visit(arg0: Internal.PoseStack$Pose_, arg1: string, arg2: number, arg3: Internal.ModelPart$Cube_): void;
        (arg0: Internal.PoseStack$Pose, arg1: string, arg2: number, arg3: Internal.ModelPart$Cube): void;
    }
    type ModelPart$Visitor_ = ModelPart$Visitor;
    interface ProcessorHandle <Msg> extends Internal.AutoCloseable {
        abstract name(): string;
        abstract tell(arg0: Msg): void;
        of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): this;
        close(): void;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, Msg>): Internal.CompletableFuture<Source>;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, Msg>): Internal.CompletableFuture<Source>;
    }
    type ProcessorHandle_<Msg> = ProcessorHandle<Msg>;
    interface IStorageComponent {
        abstract getBytes(arg0: Internal.ItemStack_): number;
        abstract isStorageComponent(arg0: Internal.ItemStack_): boolean;
    }
    type IStorageComponent_ = IStorageComponent;
    class CartographyTableMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: any_)
        constructor($$0: number, $$1: Internal.Inventory_)
        static readonly RESULT_SLOT: 2;
        static readonly MAP_SLOT: 0;
        readonly container: net.minecraft.world.Container;
        static readonly ADDITIONAL_SLOT: 1;
    }
    type CartographyTableMenu_ = CartographyTableMenu;
    class FluidIngredient$Serializer implements Internal.JsonDeserializer<slimeknights.mantle.recipe.ingredient.FluidIngredient>, Internal.JsonSerializer<slimeknights.mantle.recipe.ingredient.FluidIngredient> {
        deserialize(arg0: Internal.JsonElement_, arg1: Internal.Type_, arg2: Internal.JsonDeserializationContext_): any;
        serialize(src: slimeknights.mantle.recipe.ingredient.FluidIngredient_, typeOfSrc: Internal.Type_, context: Internal.JsonSerializationContext_): Internal.JsonElement;
        serialize(arg0: any, arg1: Internal.Type_, arg2: Internal.JsonSerializationContext_): Internal.JsonElement;
    }
    type FluidIngredient$Serializer_ = FluidIngredient$Serializer;
    class BogeyStyle implements Internal.AccessorBogeyStyle {
        constructor(id: ResourceLocation_, cycleGroup: ResourceLocation_, displayName: net.minecraft.network.chat.Component_, soundEvent: Internal.Supplier_<Internal.SoundEvent>, contactParticle: Internal.ParticleOptions_, smokeParticle: Internal.ParticleOptions_, defaultData: Internal.CompoundTag_, sizes: Internal.Map_<Internal.BogeySizes$BogeySize, Internal.Supplier<Internal.AbstractBogeyBlock<any>>>, sizeRenderers: Internal.Map_<Internal.BogeySizes$BogeySize, Internal.Supplier<Internal.Supplier<Internal.BogeyStyle$SizeRenderer>>>)
        getSizeRenderers(): Internal.Map<any, any>;
        getCycleGroup(): Internal.Map<ResourceLocation, Internal.BogeyStyle>;
        render(size: Internal.BogeySizes$BogeySize_, partialTick: number, poseStack: Internal.PoseStack_, buffers: Internal.MultiBufferSource_, light: number, overlay: number, wheelAngle: number, bogeyData: Internal.CompoundTag_, inContraption: boolean): void;
        validSizes(): Internal.Set<Internal.BogeySizes$BogeySize>;
        getNextBlock(currentSize: Internal.BogeySizes$BogeySize_): Internal.AbstractBogeyBlock<any>;
        getBlockForSize(size: Internal.BogeySizes$BogeySize_): Internal.AbstractBogeyBlock<any>;
        createVisual(size: Internal.BogeySizes$BogeySize_, ctx: Internal.VisualizationContext_, partialTick: number, inContraption: boolean): Internal.BogeyVisual;
        get sizeRenderers(): Internal.Map<any, any>
        get cycleGroup(): Internal.Map<ResourceLocation, Internal.BogeyStyle>
        readonly displayName: net.minecraft.network.chat.Component;
        readonly defaultData: Internal.CompoundTag;
        readonly contactParticle: Internal.ParticleOptions;
        readonly soundEvent: Internal.Supplier<Internal.SoundEvent>;
        readonly cycleGroup: ResourceLocation;
        readonly smokeParticle: Internal.ParticleOptions;
        readonly id: ResourceLocation;
    }
    type BogeyStyle_ = BogeyStyle;
    interface RecipeKJS {
        setGroup(group: string): void;
        getGroup(): string;
        getOrCreateId(): ResourceLocation;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getMod(): string;
        getType(): ResourceLocation;
        set group(group: string)
        get group(): string
        get orCreateId(): ResourceLocation
        get schema(): Internal.RecipeSchema
        get mod(): string
        get type(): ResourceLocation
    }
    type RecipeKJS_ = RecipeKJS;
    interface SequencedCollection <E> extends Internal.Collection<E> {
        addLast(arg0: E): void;
        getLast(): E;
        abstract add(arg0: E): boolean;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract reversed(): this;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        abstract size(): number;
        abstract hashCode(): number;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        removeLast(): E;
        spliterator(): Internal.Spliterator<E>;
        abstract equals(arg0: any): boolean;
        get last(): E
        get empty(): boolean
        get first(): E
    }
    type SequencedCollection_<E> = SequencedCollection<E>;
    abstract class TrackCouplerBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.TrackCouplerBlockEntity> {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackCouplerBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackCouplerBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityClass(): typeof Internal.TrackCouplerBlockEntity;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static create(properties: Internal.BlockBehaviour$Properties_): Internal.TrackCouplerBlock;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.TrackCouplerBlockEntity>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackCouplerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackCouplerBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.TrackCouplerBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.TrackCouplerBlockEntity>
        static readonly MODE: Internal.EnumProperty<Internal.TrackCouplerBlockEntity$AllowedOperationMode>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type TrackCouplerBlock_ = TrackCouplerBlock;
    interface BlockEntityTicker <T extends Internal.BlockEntity> {
        abstract tick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: T): void;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.BlockState, arg3: T): void;
    }
    type BlockEntityTicker_<T extends Internal.BlockEntity> = BlockEntityTicker<T>;
    class FluixHoeItem extends Internal.HoeItem implements Internal.IntrinsicEnchantItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getIntrinsicEnchantLevel(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static getTillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get tillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FluixHoeItem_ = FluixHoeItem;
    class TriState extends Internal.Enum<Internal.TriState> {
        map<T>(mapper: Internal.BooleanFunction_<T>): Internal.Optional<T>;
        orElse(value: boolean): boolean;
        static of(bool: boolean): Internal.TriState;
        orElseThrow<X extends Internal.Throwable>(exceptionSupplier: Internal.Supplier_<X>): boolean;
        static values(): Internal.TriState[];
        getBoxed(): boolean;
        static of(bool: boolean): Internal.TriState;
        static valueOf(name: string): Internal.TriState;
        get(): boolean;
        orElseGet(supplier: Internal.BooleanSupplier_): boolean;
        get boxed(): boolean
        static readonly TRUE: Internal.TriState;
        static readonly FALSE: Internal.TriState;
        static readonly DEFAULT: Internal.TriState;
    }
    type TriState_ = "false" | TriState | "default" | "true";
    interface MethodTypeDesc extends Internal.ConstantDesc, Internal.TypeDescriptor$OfMethod<Internal.ClassDesc, Internal.MethodTypeDesc> {
        displayDescriptor(): string;
        parameterArray(): Internal.TypeDescriptor$OfField<any>[];
        abstract descriptorString(): string;
        dropParameterTypes(arg0: number, arg1: number): Internal.TypeDescriptor$OfMethod<any, any>;
        abstract returnType(): Internal.ClassDesc;
        resolveConstantDesc(arg0: Internal.MethodHandles$Lookup_): any;
        abstract parameterCount(): number;
        abstract changeReturnType(arg0: Internal.ClassDesc_): this;
        of(arg0: Internal.ClassDesc_, ...arg1: Internal.ClassDesc_[]): this;
        insertParameterTypes(arg0: number, arg1: Internal.TypeDescriptor$OfField_<any>[]): Internal.TypeDescriptor$OfMethod<any, any>;
        abstract parameterList(): Internal.List<Internal.ClassDesc>;
        of(arg0: Internal.ClassDesc_): this;
        changeParameterType(arg0: number, arg1: Internal.TypeDescriptor$OfField_<any>): Internal.TypeDescriptor$OfMethod<any, any>;
        abstract changeParameterType(arg0: number, arg1: Internal.ClassDesc_): this;
        parameterType(arg0: number): Internal.TypeDescriptor$OfField<any>;
        changeReturnType(arg0: Internal.TypeDescriptor$OfField_<any>): Internal.TypeDescriptor$OfMethod<any, any>;
        abstract equals(arg0: any): boolean;
        ofDescriptor(arg0: string): this;
        of(arg0: Internal.ClassDesc_, arg1: Internal.List_<Internal.ClassDesc>): this;
        abstract insertParameterTypes(arg0: number, ...arg1: Internal.ClassDesc_[]): this;
    }
    type MethodTypeDesc_ = MethodTypeDesc;
    class VeinRecipe$Serializer <T extends Internal.VeinRecipe> implements Internal.RecipeSerializer<T> {
        constructor(type: any_<any>, create: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(pRecipeId: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork(pRecipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
        toJson(recipe: T, json: Internal.JsonObject_): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type VeinRecipe$Serializer_<T extends Internal.VeinRecipe> = VeinRecipe$Serializer<T>;
    class Typed <A> {
        constructor(arg0: com.mojang.datafixers.types.Type_<A>, arg1: Internal.DynamicOps_<any>, arg2: A)
        getAllTyped<FT>(arg0: Internal.OpticFinder_<FT>): Internal.List<Internal.Typed<FT>>;
        updateTyped<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: Internal.Function_<Internal.Typed<any>, Internal.Typed<any>>): Internal.Typed<any>;
        getValue(): A;
        inj2<B>(arg0: com.mojang.datafixers.types.Type_<B>): Internal.Typed<Internal.Either<B, A>>;
        getType(): com.mojang.datafixers.types.Type<A>;
        updateRecursive<FT>(arg0: Internal.OpticFinder_<FT>, arg1: Internal.Function_<FT, FT>): Internal.Typed<any>;
        out(): this;
        getOrCreateTyped<FT>(arg0: Internal.OpticFinder_<FT>): Internal.Typed<FT>;
        getTyped<FT>(arg0: Internal.OpticFinder_<FT>): Internal.Typed<FT>;
        getAll<FT>(arg0: Internal.TypedOptic_<A, any, FT, any>): Internal.List<FT>;
        getOptional<FT>(arg0: Internal.OpticFinder_<FT>): Internal.Optional<FT>;
        getOptionalTyped<FT>(arg0: Internal.OpticFinder_<FT>): Internal.Optional<Internal.Typed<FT>>;
        update<FT>(arg0: Internal.OpticFinder_<FT>, arg1: Internal.Function_<FT, FT>): Internal.Typed<any>;
        updateRecursiveTyped<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: Internal.Function_<Internal.Typed<any>, Internal.Typed<any>>): Internal.Typed<any>;
        updateTyped<FT>(arg0: Internal.OpticFinder_<FT>, arg1: Internal.Function_<Internal.Typed<any>, Internal.Typed<any>>): Internal.Typed<any>;
        getOps(): Internal.DynamicOps<any>;
        inj1<B>(arg0: com.mojang.datafixers.types.Type_<B>): Internal.Typed<Internal.Either<A, B>>;
        updateRecursive<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: Internal.Function_<FT, FR>): Internal.Typed<any>;
        getOrCreate<FT>(arg0: Internal.OpticFinder_<FT>): FT;
        updateRecursiveTyped<FT>(arg0: Internal.OpticFinder_<FT>, arg1: Internal.Function_<Internal.Typed<any>, Internal.Typed<any>>): Internal.Typed<any>;
        set<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: FR): Internal.Typed<any>;
        write(): Internal.DataResult<Internal.Dynamic<any>>;
        getOrDefault<FT>(arg0: Internal.OpticFinder_<FT>, arg1: FT): FT;
        static pair<A, B>(arg0: Internal.Typed_<A>, arg1: Internal.Typed_<B>): Internal.Typed<com.mojang.datafixers.util.Pair<A, B>>;
        get<FT>(arg0: Internal.OpticFinder_<FT>): FT;
        update<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: Internal.Function_<FT, FR>): Internal.Typed<any>;
        set<FT>(arg0: Internal.OpticFinder_<FT>, arg1: FT): Internal.Typed<any>;
        set<FT, FR>(arg0: Internal.OpticFinder_<FT>, arg1: Internal.Typed_<FR>): Internal.Typed<any>;
        get value(): A
        get type(): com.mojang.datafixers.types.Type<A>
        get ops(): Internal.DynamicOps<any>
    }
    type Typed_<A> = Typed<A>;
    class AbuseReportRequest$ClientInfo {
        constructor(arg0: string, arg1: string)
        locale: string;
        clientVersion: string;
    }
    type AbuseReportRequest$ClientInfo_ = AbuseReportRequest$ClientInfo;
    class BannerItem extends Internal.StandingAndWallBlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Block_, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static appendHoverTextFromBannerBlockEntityTag($$0: Internal.ItemStack_, $$1: Internal.List_<net.minecraft.network.chat.Component>): void;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getColor(): Internal.DyeColor;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get color(): Internal.DyeColor
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BannerItem_ = BannerItem;
    class IronGolem$Crackiness extends Internal.Enum<Internal.IronGolem$Crackiness> {
        static valueOf($$0: string): Internal.IronGolem$Crackiness;
        static values(): Internal.IronGolem$Crackiness[];
        static byFraction($$0: number): Internal.IronGolem$Crackiness;
        static readonly NONE: Internal.IronGolem$Crackiness;
        static readonly LOW: Internal.IronGolem$Crackiness;
        static readonly HIGH: Internal.IronGolem$Crackiness;
        static readonly MEDIUM: Internal.IronGolem$Crackiness;
    }
    type IronGolem$Crackiness_ = "medium" | "high" | "low" | "none" | IronGolem$Crackiness;
    interface ItemExtras {
        hasSecondaryUse(stack: Internal.ItemStack_, level: Internal.LevelReader_, pos: BlockPos_, player: Internal.Player_): Internal.TriState;
    }
    type ItemExtras_ = ItemExtras;
    class BlockSlipway extends Internal.Block implements Internal.IForgeLikeBlock, Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(blockPos: BlockPos_, blockState: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        newBlockEntity(pPos: BlockPos_, pState: Internal.BlockState_): Internal.BlockEntitySlipway;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, pBlockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        hasEnchantPowerBonus(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): boolean;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        addLandingEffects(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly Companion: Internal.BlockSlipway$Companion;
    }
    type BlockSlipway_ = BlockSlipway;
    class ShepherdsPieBlock extends Internal.FeastBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, servingItem: Internal.Supplier_<Internal.Item>, hasLeftovers: boolean)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ShepherdsPieBlock_ = ShepherdsPieBlock;
    class PigmentIota$Companion {
        constructor($constructor_marker: any_)
        getTYPE(): Internal.IotaType<Internal.PigmentIota>;
        setTYPE(<set-?>: Internal.IotaType_<Internal.PigmentIota>): void;
        get TYPE(): Internal.IotaType<Internal.PigmentIota>
        set TYPE(<set-?>: Internal.IotaType_<Internal.PigmentIota>)
    }
    type PigmentIota$Companion_ = PigmentIota$Companion;
    class JsonPrimitive extends Internal.JsonElement {
        constructor(arg0: string)
        constructor(arg0: number)
        constructor(arg0: boolean)
        constructor(arg0: string)
        isString(): boolean;
        isBoolean(): boolean;
        isNumber(): boolean;
        get string(): boolean
        get "boolean"(): boolean
        get number(): boolean
    }
    type JsonPrimitive_ = JsonPrimitive;
    class AbuseReportLimits extends Internal.Record {
        constructor(maxOpinionCommentsLength: number, maxReportedMessageCount: number, maxEvidenceMessageCount: number, leadingContextMessageCount: number, trailingContextMessageCount: number)
        maxReportedMessageCount(): number;
        maxEvidenceMessageCount(): number;
        leadingContextMessageCount(): number;
        trailingContextMessageCount(): number;
        maxOpinionCommentsLength(): number;
        static readonly DEFAULTS: Internal.AbuseReportLimits;
    }
    type AbuseReportLimits_ = AbuseReportLimits;
    class SymmetryWandItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        static apply(world: Internal.Level_, wand: Internal.ItemStack_, player: Internal.Player_, pos: BlockPos_, block: Internal.BlockState_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static getMirror(stack: Internal.ItemStack_): Internal.SymmetryMirror;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static configureSettings(stack: Internal.ItemStack_, mirror: Internal.SymmetryMirror_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static presentInHotbar(player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static handlePostEvent(world: Internal.Level_, player: Internal.Player_, pos: BlockPos_, state: Internal.BlockState_, be: Internal.BlockEntity_): void;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        static remove(world: Internal.Level_, wand: Internal.ItemStack_, player: Internal.Player_, pos: BlockPos_, ogBlock: Internal.BlockState_): void;
        static isEnabled(stack: Internal.ItemStack_): boolean;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static handlePreEvent(world: Internal.Level_, player: Internal.Player_, pos: BlockPos_, state: Internal.BlockState_, be: Internal.BlockEntity_): boolean;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly SYMMETRY: "symmetry";
    }
    type SymmetryWandItem_ = SymmetryWandItem;
    class Month extends Internal.Enum<Internal.Month> implements Internal.TemporalAccessor, Internal.TemporalAdjuster {
        static of(arg0: number): Internal.Month;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        static values(): Internal.Month[];
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        minLength(): number;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        minus(arg0: number): this;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        length(arg0: boolean): number;
        static from(arg0: Internal.TemporalAccessor_): Internal.Month;
        get(arg0: Internal.TemporalField_): number;
        plus(arg0: number): this;
        getLong(arg0: Internal.TemporalField_): number;
        firstMonthOfQuarter(): this;
        firstDayOfYear(arg0: boolean): number;
        maxLength(): number;
        getValue(): number;
        static valueOf(arg0: string): Internal.Month;
        isSupported(arg0: Internal.TemporalField_): boolean;
        get value(): number
        static readonly JANUARY: Internal.Month;
        static readonly JUNE: Internal.Month;
        static readonly FEBRUARY: Internal.Month;
        static readonly APRIL: Internal.Month;
        static readonly MAY: Internal.Month;
        static readonly MARCH: Internal.Month;
        static readonly AUGUST: Internal.Month;
        static readonly OCTOBER: Internal.Month;
        static readonly JULY: Internal.Month;
        static readonly SEPTEMBER: Internal.Month;
        static readonly NOVEMBER: Internal.Month;
        static readonly DECEMBER: Internal.Month;
    }
    type Month_ = "march" | "april" | "september" | "may" | "june" | "august" | Month | "december" | "january" | "july" | "october" | "february" | "november";
    class DataPackConfig {
        constructor($$0: Internal.List_<string>, $$1: Internal.List_<string>)
        getEnabled(): Internal.List<string>;
        getDisabled(): Internal.List<string>;
        get enabled(): Internal.List<string>
        get disabled(): Internal.List<string>
        static readonly CODEC: Internal.Codec<Internal.DataPackConfig>;
        static readonly DEFAULT: Internal.DataPackConfig;
    }
    type DataPackConfig_ = DataPackConfig;
    interface BeaconBlockEntityAccessor {
        abstract port_lib$getBeamSections(): Internal.List<Internal.BeaconBlockEntity$BeaconBeamSection>;
        (): Internal.List_<Internal.BeaconBlockEntity$BeaconBeamSection>;
    }
    type BeaconBlockEntityAccessor_ = BeaconBlockEntityAccessor;
    class Label extends Internal.AbstractSimiWidget {
        constructor(x: number, y: number, text: net.minecraft.network.chat.Component_)
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        withShadow(): this;
        colored(color: number): this;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        moveTo(x: number, y: number): void;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        mouseMoved($$0: number, $$1: number): void;
        withSuffix(s: string): this;
        setTextAndTrim(newText: net.minecraft.network.chat.Component_, trimFront: boolean, maxWidthPx: number): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        setPosition($$0: number, $$1: number): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        get currentFocusPath(): Internal.ComponentPath
        suffix: string;
        text: net.minecraft.network.chat.Component;
    }
    type Label_ = Label;
    class ToolHarvestContext {
        constructor(world: Internal.ServerLevel_, living: Internal.LivingEntity_, state: Internal.BlockState_, pos: BlockPos_, sideHit: Internal.Direction_, canHarvest: boolean, isEffective: boolean)
        constructor(world: Internal.ServerLevel_, player: Internal.ServerPlayer_, state: Internal.BlockState_, pos: BlockPos_, sideHit: Internal.Direction_, canHarvest: boolean, isEffective: boolean)
        isEffective(): boolean;
        getPos(): BlockPos;
        forPosition(pos: BlockPos_, state: Internal.BlockState_): this;
        isAOE(): boolean;
        canHarvest(): boolean;
        getSideHit(): Internal.Direction;
        getTargetedState(): Internal.BlockState;
        getLiving(): Internal.LivingEntity;
        getWorld(): Internal.ServerLevel;
        getTargetedPos(): BlockPos;
        getState(): Internal.BlockState;
        getPlayer(): Internal.ServerPlayer;
        get effective(): boolean
        get pos(): BlockPos
        get AOE(): boolean
        get sideHit(): Internal.Direction
        get targetedState(): Internal.BlockState
        get living(): Internal.LivingEntity
        get world(): Internal.ServerLevel
        get targetedPos(): BlockPos
        get state(): Internal.BlockState
        get player(): Internal.ServerPlayer
    }
    type ToolHarvestContext_ = ToolHarvestContext;
    interface Vector4dc {
        abstract get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
        abstract distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract normalize(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract negate(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Vector4d_): Internal.Vector4d;
        abstract z(): number;
        abstract isFinite(): boolean;
        abstract sub(arg0: Internal.Vector4fc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract angleCos(arg0: Internal.Vector4dc_): number;
        abstract get(arg0: Vec4f_): Vec4f;
        abstract fma(arg0: Internal.Vector4dc_, arg1: Internal.Vector4dc_, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract getToAddress(arg0: number): this;
        abstract equals(arg0: Internal.Vector4dc_, arg1: number): boolean;
        abstract get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract ceil(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract x(): number;
        abstract div(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract min(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Matrix4fc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract normalize(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract distanceSquared(arg0: Internal.Vector4dc_): number;
        abstract mulTranspose(arg0: Internal.Matrix4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract mulAffine(arg0: Internal.Matrix4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract floor(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract mulAdd(arg0: number, arg1: Internal.Vector4dc_, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Matrix4x3fc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateY(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract length(): number;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mulProject(arg0: Internal.Matrix4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract minComponent(): number;
        abstract add(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract normalize3(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract maxComponent(): number;
        abstract getf(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract distance(arg0: Internal.Vector4dc_): number;
        abstract smoothStep(arg0: Internal.Vector4dc_, arg1: number, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract max(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Vector4fc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract lerp(arg0: Internal.Vector4dc_, arg1: number, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract fma(arg0: number, arg1: Internal.Vector4dc_, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract getf(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract angle(arg0: Internal.Vector4dc_): number;
        abstract mulProject(arg0: Internal.Matrix4dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract sub(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract div(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract w(): number;
        abstract get(arg0: number): number;
        abstract y(): number;
        abstract lengthSquared(): number;
        abstract mul(arg0: Internal.Matrix4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract absolute(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract rotate(arg0: Internal.Quaterniondc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract mulAffineTranspose(arg0: Internal.Matrix4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract dot(arg0: Internal.Vector4dc_): number;
        abstract round(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Matrix4x3dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateX(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateZ(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract mulAdd(arg0: Internal.Vector4dc_, arg1: Internal.Vector4dc_, arg2: Internal.Vector4d_): Internal.Vector4d;
        abstract hermite(arg0: Internal.Vector4dc_, arg1: Internal.Vector4dc_, arg2: Internal.Vector4dc_, arg3: number, arg4: Internal.Vector4d_): Internal.Vector4d;
        abstract add(arg0: Internal.Vector4fc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        get finite(): boolean
    }
    type Vector4dc_ = Vector4dc;
    class DropExperienceBlock extends Internal.Block implements Internal.CustomExpBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.IntProvider_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getExpDrop(state: Internal.BlockState_, level: Internal.LevelReader_, randomSource: Internal.RandomSource_, pos: BlockPos_, fortuneLevel: number, silkTouchLevel: number): number;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type DropExperienceBlock_ = DropExperienceBlock;
    interface IDistanceTravelled {
        abstract railways$getDistanceTravelled(): number;
        (): number;
    }
    type IDistanceTravelled_ = IDistanceTravelled;
    class ClientboundChunksBiomesPacket$ChunkBiomeData extends Internal.Record {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.LevelChunk_)
        constructor($$0: Internal.ChunkPos_, $$1: number[])
        write($$0: Internal.FriendlyByteBuf_): void;
        buffer(): number[];
        getReadBuffer(): Internal.FriendlyByteBuf;
        pos(): Internal.ChunkPos;
        static extractChunkData($$0: Internal.FriendlyByteBuf_, $$1: Internal.LevelChunk_): void;
        get readBuffer(): Internal.FriendlyByteBuf
    }
    type ClientboundChunksBiomesPacket$ChunkBiomeData_ = ClientboundChunksBiomesPacket$ChunkBiomeData;
    interface CastingEnvironmentComponent {
        abstract getKey(): Internal.CastingEnvironmentComponent$Key<any>;
        get key(): Internal.CastingEnvironmentComponent$Key<any>
        (): Internal.CastingEnvironmentComponent$Key_<any>;
    }
    type CastingEnvironmentComponent_ = CastingEnvironmentComponent;
    abstract class ContentHandler {
        constructor()
        abstract getContent(arg0: Internal.URLConnection_): any;
        getContent(arg0: Internal.URLConnection_, arg1: typeof any[]): any;
    }
    type ContentHandler_ = ContentHandler;
    interface PlayerExtension {
        setDigSpeedContext(pos: BlockPos_): void;
        getDigSpeed(state: Internal.BlockState_, pos: BlockPos_): number;
        set digSpeedContext(pos: BlockPos_)
    }
    type PlayerExtension_ = PlayerExtension;
    interface ContainerListener extends Internal.EventListener {
        abstract componentRemoved(arg0: Internal.ContainerEvent_): void;
        abstract componentAdded(arg0: Internal.ContainerEvent_): void;
    }
    type ContainerListener_ = ContainerListener;
    abstract class CastingEnvironment {
        assertVecInWorld(vec: Vec3d_): void;
        static addCreateEventListener(listener: Internal.BiConsumer_<Internal.CastingEnvironment, Internal.CompoundTag>): void;
        canEditBlockAt(vec: BlockPos_): boolean;
        withdrawItem(stackOk: Internal.Predicate_<Internal.ItemStack>, count: number, actuallyRemove: boolean): boolean;
        precheckAction(match: Internal.PatternShapeMatch_): void;
        abstract replaceItem(arg0: Internal.Predicate_<Internal.ItemStack>, arg1: Internal.ItemStack_, arg2: Internal.InteractionHand_): boolean;
        isVecInWorld(vec: Vec3d_): boolean;
        extractMedia(cost: number, simulate: boolean): number;
        isEntityInRange(e: Internal.Entity_, ignoreTruenameAmbit: boolean): boolean;
        assertEntityInRange(e: Internal.Entity_): void;
        isVecInAmbit(vec: Vec3d_): boolean;
        /**
         * @deprecated
        */
        getCaster(): Internal.ServerPlayer;
        getOtherHand(): Internal.InteractionHand;
        abstract getPigment(): Internal.FrozenPigment;
        assertVecInRange(vec: Vec3d_): void;
        postExecution(result: Internal.CastResult_): void;
        queryForMatchingStack(stackOk: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        getHeldItemToOperateOn(stackOk: Internal.Predicate_<Internal.ItemStack>): Internal.CastingEnvironment$HeldItemInfo;
        maxOpCount(): number;
        getWorld(): Internal.ServerLevel;
        replaceItemForPlayer(stackOk: Internal.Predicate_<Internal.ItemStack>, replaceWith: Internal.ItemStack_, hand: Internal.InteractionHand_, caster: Internal.ServerPlayer_): boolean;
        isEntityInRange(e: Internal.Entity_): boolean;
        postCast(image: Internal.CastingImage_): void;
        abstract printMessage(arg0: net.minecraft.network.chat.Component_): void;
        abstract getMishapEnvironment(): Internal.MishapEnvironment;
        abstract setPigment(arg0: Internal.FrozenPigment_): Internal.FrozenPigment;
        assertPosInRange(vec: BlockPos_): void;
        /**
         * @deprecated
        */
        static addCreateEventListener(listener: Internal.Consumer_<Internal.CastingEnvironment>): void;
        abstract getCastingEntity(): Internal.LivingEntity;
        triggerCreateEvent(userData: Internal.CompoundTag_): void;
        assertPosInRangeForEditing(vec: BlockPos_): void;
        removeExtension(key: Internal.CastingEnvironmentComponent$Key_<any>): void;
        abstract produceParticles(arg0: Internal.ParticleSpray_, arg1: Internal.FrozenPigment_): void;
        hasEditPermissionsAt(pos: BlockPos_): boolean;
        abstract getCastingHand(): Internal.InteractionHand;
        abstract mishapSprayPos(): Vec3d;
        getExtension<T extends Internal.CastingEnvironmentComponent>(key: Internal.CastingEnvironmentComponent$Key_<T>): T;
        isEnlightened(): boolean;
        isVecInRange(vec: Vec3d_): boolean;
        addExtension<T extends Internal.CastingEnvironmentComponent>(extension: T): void;
        /**
         * @deprecated
        */
        get caster(): Internal.ServerPlayer
        get otherHand(): Internal.InteractionHand
        get pigment(): Internal.FrozenPigment
        get world(): Internal.ServerLevel
        get mishapEnvironment(): Internal.MishapEnvironment
        set pigment(arg0: Internal.FrozenPigment_)
        get castingEntity(): Internal.LivingEntity
        get castingHand(): Internal.InteractionHand
        get enlightened(): boolean
    }
    type CastingEnvironment_ = CastingEnvironment;
    class RealmsServerAddress extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.RealmsServerAddress;
        resourcePackUrl: string;
        address: string;
        resourcePackHash: string;
    }
    type RealmsServerAddress_ = RealmsServerAddress;
    class PalettedContainer$Configuration <T> extends Internal.Record {
        constructor($$0: Internal.Palette$Factory_, $$1: number)
        bits(): number;
        factory(): Internal.Palette$Factory;
        createData($$0: Internal.IdMap_<T>, $$1: Internal.PaletteResize_<T>, $$2: number): Internal.PalettedContainer$Data<T>;
    }
    type PalettedContainer$Configuration_<T> = PalettedContainer$Configuration<T>;
    class ModifierRecipe$Serializer extends Internal.AbstractModifierRecipe$Serializer<Internal.ModifierRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): Internal.AbstractModifierRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): Internal.AbstractModifierRecipe;
    }
    type ModifierRecipe$Serializer_ = ModifierRecipe$Serializer;
    class SugarCaneBlock extends Internal.Block implements Internal.IPlantable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
    }
    type SugarCaneBlock_ = SugarCaneBlock;
    interface FogShader {
        abstract source(): ResourceLocation;
        (): ResourceLocation_;
    }
    type FogShader_ = FogShader;
    class BlendingData {
        static sideByGenerationAge($$0: Internal.WorldGenLevel_, $$1: number, $$2: number, $$3: boolean): Internal.Set<Internal.Direction8>;
        getAreaWithOldGeneration(): Internal.LevelHeightAccessor;
        static getOrUpdateBlendingData($$0: Internal.WorldGenRegion_, $$1: number, $$2: number): Internal.BlendingData;
        get areaWithOldGeneration(): Internal.LevelHeightAccessor
        static readonly CODEC: Internal.Codec<Internal.BlendingData>;
    }
    type BlendingData_ = BlendingData;
    class ItemTrollWeapon extends Internal.SwordItem {
        constructor(weapon: Internal.TrollType$ITrollWeapon_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        onEntitySwing(LivingEntity: Internal.LivingEntity_, stack: Internal.ItemStack_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly weapon: Internal.TrollType$ITrollWeapon;
    }
    type ItemTrollWeapon_ = ItemTrollWeapon;
    class SmallIndustrialLampBlock extends Internal.IndustrialLampBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly EAST_SHAPE: Internal.ArrayVoxelShape;
        static readonly DOWN_SHAPE: Internal.ArrayVoxelShape;
        static readonly SOUTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly WEST_SHAPE: Internal.ArrayVoxelShape;
        static readonly NORTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly UP_SHAPE: Internal.ArrayVoxelShape;
    }
    type SmallIndustrialLampBlock_ = SmallIndustrialLampBlock;
    abstract class AbstractTurtleUpgrade implements Internal.ITurtleUpgrade {
        getType(): Internal.TurtleUpgradeType;
        getUpgradeID(): ResourceLocation;
        getPersistedData(upgradeData: Internal.CompoundTag_): Internal.CompoundTag;
        useTool(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_, verb: Internal.TurtleVerb_, direction: Internal.Direction_): Internal.TurtleCommandResult;
        getCraftingItem(): Internal.ItemStack;
        getUpgradeData(stack: Internal.ItemStack_): Internal.CompoundTag;
        static getDefaultAdjective(id: ResourceLocation_): string;
        createPeripheral(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_): Internal.IPeripheral;
        getUnlocalisedAdjective(): string;
        update(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_): void;
        isItemSuitable(stack: Internal.ItemStack_): boolean;
        getUpgradeItem(upgradeData: Internal.CompoundTag_): Internal.ItemStack;
        get type(): Internal.TurtleUpgradeType
        get upgradeID(): ResourceLocation
        get craftingItem(): Internal.ItemStack
        get unlocalisedAdjective(): string
    }
    type AbstractTurtleUpgrade_ = AbstractTurtleUpgrade;
    class EjectorBlockEntity extends Internal.KineticBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getLaunchedItemLocation(time: number): Vec3d;
        getLidProgress(pt: number): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setTarget(horizontalDistance: number, verticalDistance: number): void;
        activate(): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        activateDeferred(): void;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getLaunchedItemMotion(time: number): Vec3d;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getTargetOpenInv(): Internal.DirectBeltInputBehaviour;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getTargetPosition(): BlockPos;
        updateSignal(): void;
        getWindUpSpeed(): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        getState(): Internal.EjectorBlockEntity$State;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        deployElytra(playerEntity: Internal.Player_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        dropFlyingItems(): void;
        get targetOpenInv(): Internal.DirectBeltInputBehaviour
        get targetPosition(): BlockPos
        get windUpSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        get state(): Internal.EjectorBlockEntity$State
    }
    type EjectorBlockEntity_ = EjectorBlockEntity;
    class FleshTendonsBlock extends Internal.HangingStrandBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FleshTendonsBlock_ = FleshTendonsBlock;
}
